# agent-audio.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/net/agent-audio.tcl,v 1.69 2002/02/03 04:28:05 lim Exp $


import RTPAgent RTP/Audio Configuration \
	AnnounceListenManager/AS/Client/MeGa/Audio

Module/AudioEncoder set nb_ 0
if [TclObject is-class Audio] {
	Audio set duplex_ 1
}
AudioController set echo_thresh_ 0
AudioController set echo_suppress_time_ 0
AudioController set idle_drop_time_ 0


# The AudioAgent class provides a coarse-grained interface
# that abstracts away all the details of networked audio.
# This agent is responsible for creating the underlying RTP
# session for the audio channel, for opening and initializing
# the audio codec hardware, and for creating the AudioController
# that orchestrates the timing and synchronization of all
# audio events.
# <p>
# Since AudioAgent is derived from the RTPAgent base class,
# the standard RTP observer API is supported.  Any ``interesting''
# events (e.g., the arrival of a new RTP flow) within the underlying
# RTP sessions are relayed to all the observers attached to this agent.
# (Note that the AudioAgent class catches and handles some of the
# events on its own.)
# <p>
# Typically, a mash script will create a separate user interface
# object and attach it to the AudioAgent as an Observer.
#
Class AudioAgent -superclass { RTPAgent RTP/Audio } -configuration {
	megaAudioFormat gsm
	# multicast is default
	megaRecvAudioPort 0
	audioSessionBW 20
	megaAudioCtrl 224.4.5.24/50000/31
	audioServiceLocation urn:agw
}

#
# Initialize a new instance of an AudioAgent.
# initialize the network (alot of it is done
# in the parent classes) and setup the audioStream
#
AudioAgent public init { app spec {callback {}} } {
        if { $spec != "" } {
		set ab [new AddressBlock $spec]
		set fmt [$ab fmt]
		if { $fmt != {} } { $self add_option audioFormat $fmt }
	} else {
		set ab ""
	}
	
	$self next $ab $callback
	if { $ab != "" } {
		delete $ab
	}

	# send back-to-back packets spaced out at 128kb/s
	$self set-bandwidth 1280000

	#FIXME
	$self site-drop-time [$self get_option siteDropTime]


	$self instvar decoders_ audioDevice_ sampRate use16bit useStereo deviceName
	set decoders_ ""

	#
	# Set up a table to map lower-case RTP format
	# names into the suffix of the class name
	# that encodes or decodes this type
	#
	$self instvar classmap_
	set classmap_(pcm) PCM
	set classmap_(lpc) LPC
	set classmap_(gsm) GSM
	set classmap_(dvi) ADPCM
	set classmap_(mp3) MP3
	# added so vat supports linear 16, used with aserver
	set classmap_(lin16) PCM
#	$self start_mega
	$self instvar session_
	if ![info exists sampRate] {
	    set sampRate 8000
	}
	if ![info exists use16bit] {
	    set use16bit 0
	}
	if ![info exists useStereo] {
	    set useStereo 0
	}

	if ![info exists deviceName] {
	    set audioDevice_ [new AudioStream $session_ $sampRate $use16bit $useStereo]
	} else {
	    set audioDevice_ [new AudioStream $session_ $sampRate $use16bit $useStereo $deviceName]
	}
}

# old code, no longer used
AudioAgent public start_mega { } {
	$self instvar al_
	if [info exists al_] { delete $al_ }
	if { [$self get_option megaAudioSession] != "" } {
		set sname [$self get_option megaAudioSession]
		set sspec [$self get_option audioSessionSpec]
		set rportspec [$self get_option megaRecvAudioPort]
	        set ofmt [$self get_option megaAudioFormat]
		set sbw [$self get_option audioSessionBW]
		set bw [expr 0.02*$sbw*1000]
		set megaspec [$self get_option megaAudioCtrl]
	        set loc [$self get_option audioServiceLocation]

		set ab [new AddressBlock $sspec]
		set sspec [$ab addr]/[$ab sport]:[$ab rport]/[$ab ttl]
		delete $ab
		set al_ [new AnnounceListenManager/AS/Client/MeGa/Audio \
				$self $megaspec $bw [Application name] audio \
				$sname $sspec $rportspec $ofmt $loc]
		$al_ start
	}
}


#
# Deallocate all the resources associated with
# the AudioAgent class.  Close the audio device
# (and implicitly delete it) and free up the buffer pool.
#
AudioAgent public destroy {} {
    $self instvar al_ audioDevice_
    if [info exists audioDevice_] { delete $audioDevice_ } 
    if [info exists al_] { delete $al_ }
    $self next
}

# old code, no longer used
# Used when we need to point the mega audio gateway we're controlling
# to listen to a new source.  This is kludgy, and needs a redesign.
#
AudioAgent public reset_mega {} {
	$self instvar al_
	if ![info exists al_] {
		$self start_mega
	} else {
		$al_ reset_spec [$self get_option audioSessionSpec]
	}
}

#
# Handle an activate event on source <i>src</i>.
# Called from C++ (through Source/RTP) when we start
# actively receiving data pkts from the given source.
# Create the decoder and dispatch the method to the
# observers as normal.
# Extends method in RTPAgent.
#
AudioAgent private activate src {
	$self instvar decoders_
	set d [$self create_decoder $src]
	lappend decoders_ $d
	$src handler $d
	$self next $src
}

#
# Handle a deactivate event on source <i>src</i>.
# Called from C++ (through Source/RTP) when a source
# has left the session (either via an RTCP BYE message
# or via an expiration timer).  This method can also
# get called back if the Source object is explicitly
# deleted from the local program.
# Extends method in RTPAgent.
#
AudioAgent private deactivate src {
	$self instvar decoders_
	set d [$src handler]
	set k [lsearch -exact $decoders_ $d]
	set decoders_ [lreplace $decoders_ $k $k]
	$self next $src
	delete $d
}

#
# Handle a media-trigger event on source <i>src</i>.
# Called from C++ (through Source/RTP) when a data packet
# arrives from source <i>src</i> and its media trigger is enabled.
# Extends method in RTPAgent.
#

AudioAgent instproc trigger_media src {
	$self instvar local_chan_
	if [info exists local_chan_] {
		set cname [$src sdes cname]
		if { "$cname" != "" } {
			$local_chan_ send FOCUS_SPEAKER $cname
		}
	}
	$self next $src
}

#
# Attach a CoordinationBus object to this agent.
# When present, the coordination bus enables a number
# of inter-agent interactions, e.g., voice-switched-video
# windows orchestrated between video and audio agents.
#

AudioAgent instproc attach_local_channel lc {
        $self set local_chan_ $lc
}
AudioAgent instproc attach_global_channel gc {
        $self set glob_chan_ $gc
}

#
# Called by the underlying network object when the number
# of media layers expected across all sources changes.
# For example, an underlying network protocol might adjust
# the number of multicast channels received to carry out
# congestion control.  When the level of subscription changes,
# the codecs must be informed so that they do not wait
# unnecessarily for packets that will never arrive (because
# the corresponding layer is not present).
# <p>
# Extends method in RTPAgent.
#
AudioAgent private set_maxchannel n {
	global active
	foreach s [array names active] {
		set d [$s handler]
		$d set maxChannel_ $n
	}
}

#
# Create an audio decoder that can decode the RTP flow
# from source <i>src</i>.  Assumes this source has received
# media packets so we can determine the RTP payload type
# and allocate an appropriate decoder.  If the system
# does not support the media type, a ``null decoder'' is
# created and returned.
#
AudioAgent public create_decoder src {
    $self instvar classmap_ audioDevice_
    if ![info exists classmap_([$src format_name])] {
	# don't support this format
	set decoder [new Module/AudioDecoder/Null]
    } else {
	set decoder [new Module/AudioDecoder/$classmap_([$src format_name])]
    }
    
    if { $decoder == "" } {
	# don't support this format
	set decoder [new Module/AudioDecoder/Null]
    }
    #FIXME
    set controller [$audioDevice_ get_controller]
    if { $controller == 0 } {
	puts stderr "AudioAgent: no audio controller."
	exit 0
    }
    $decoder set agent_ $self
    $decoder set src_ $src
    $decoder controller $controller
    $src handler $decoder
    
    return $decoder
}

#
# Create a Session object that appropriate for this
# type of agent.  Called by the RTPAgent class when
# initializing the network state.
#
AudioAgent private create_session {} {
	return [new Session/RTP/Audio]
}

#
# Assign a new address (or set of addresses) to the
# underlying communication session.  The address(es)
# must be in the AddressBlock object given by <i>ab</i>.
#
AudioAgent public reset ab {
	$self next $ab
	#
	# audio shouldn't be looped back (unlike video),
	# but if we might want to loop it back to other processes
	# running on the local host (if the option is enabled)
	#
	$self app_loopback 0
	$self net_loopback [$self get_option loopback]
	$self set-bandwidth 128000

	$self instvar set_pool_srcid_
	if ![info exists set_pool_srcid_] {
	    # not too sure when this is used, kind of an ad hoc way of doing it...
#	    $self instvar audioDevice_
#	    set bufferPool [set $audioDevice_ bufferPool_]
#	    if ![info exists bufferPool]  {
#		set bufferPool [new BufferPool/RTP]
#	    }
#	    $bufferPool srcid [$self get_local_srcid]
	    set set_pool_srcid_ 1
	}
}

#
# Reset the clock offset of each Source object in the underlying
# communication session.  The clock offset is the skew between
# the sender's media timestamp and the local media time.
# Rather than run an elaborate synchronization scheme, the offset
# is computed and set at the start of each talk spurt.
# Since these offsets can drift when the Controller object
# is not running off the audio clock, this time base can
# shift pretty badly (especially on PC's where gettimeofday
# accuracy is low).  This hook allows the UI to note when
# the device is re-gained so that the offsets can be explicitly reset.
# FIXME - this is too much exposure of mechanism.  Figure out
# how to hide this.  The AudioAgent should be able to tell on
# its own thtat the device is re-obtained and should do the
# reset then...  Also, delay adaptation state
# should be kept in the source object... (and this method should
# live in RtpAgent)
#
AudioAgent instproc reset_source_offsets {} {
	$self instvar decoders_
	foreach d $decoders_ {
		$d reset-offset
	}
}

# a bunch of calls that just forward to the audioDevice_...

AudioAgent public bind_transducer { which o } {
    $self instvar audioDevice_
    $audioDevice_ bind_transducer $which $o
}

AudioAgent public have_audio {} {
	$self instvar audioDevice_
	if [info exists audioDevice_] {
		return [$audioDevice_ have_audio]
	}
	return 0
}

AudioAgent public set_input_mute val {
    $self instvar audioDevice_
    $audioDevice_ set_input_mute $val
}

AudioAgent public set_output_mute val {
    $self instvar audioDevice_
    $audioDevice_ set_output_mute $val
}

AudioAgent public get_input_ports {} {
    $self instvar audioDevice_
    return [$audioDevice_ get_input_ports]
}

AudioAgent public get_output_ports {} {
    $self instvar audioDevice_
    return [$audioDevice_ get_output_ports]
}

AudioAgent public is_halfduplex {} {
    $self instvar audioDevice_
    return [$audioDevice_ is_halfduplex]
}

AudioAgent public get_input_portno { } {
    $self instvar audioDevice_
    return [$audioDevice_ get_input_portno]
}

AudioAgent public get_output_portno { } {
    $self instvar audioDevice_
    return [$audioDevice_ get_output_portno]
}

AudioAgent public set_speakerphone { port mode } {
    $self instvar audioDevice_
    $audioDevice_ set_speakerphone $port $mode
}

AudioAgent public audio_test type {
    $self instvar audioDevice_
    $audioDevice_ audio_test $type
}

AudioAgent public port_name_to_num { which name } {
    $self instvar audioDevice_
    return [$audioDevice_ port_name_to_num $which $name]
}

AudioAgent public set_input_port port {
    $self instvar audioDevice_
    $audioDevice_ set_input_port $port
}

AudioAgent public set_output_port port {
    $self instvar audioDevice_
    $audioDevice_ set_output_port $port
}

AudioAgent public set_input_gain gain {
    $self instvar audioDevice_
    return [$audioDevice_ set_input_gain $gain]
}

AudioAgent public set_output_gain gain {
    $self instvar audioDevice_
    return [$audioDevice_ set_output_gain $gain]
}

AudioAgent public get_input_gain {} {
    $self instvar audioDevice_
    return [$audioDevice_ get_input_gain]
}

AudioAgent public get_output_gain {} {
    $self instvar audioDevice_
    return [$audioDevice_ get_output_gain]
}

AudioAgent public is_active {} {
    $self instvar audioDevice_
    return [$audioDevice_ is_active]
}

AudioAgent public clear_active {} {
    $self instvar audioDevice_
    $audioDevice_ clear_active
}

AudioAgent public select_format { fmt BlksPerPkt } {
    $self instvar audioDevice_
    $audioDevice_ select_format $fmt $BlksPerPkt
}

AudioAgent public set_silence_thresh thresh {
    $self instvar audioDevice_
    $audioDevice_ set_silence_thresh $thresh
}

AudioAgent public release {} {
    $self instvar audioDevice_
    $audioDevice_ release
}

AudioAgent public obtain {} {
    $self instvar audioDevice_
    $audioDevice_ obtain
}

AudioAgent instproc unix_time {} {
    $self instvar audioDevice_
    set controller [$audioDevice_ get_controller]
    if { $controller == 0 } {
	return 0
    }
    return [$controller unix_time]
}

AudioAgent instproc ntp_time {} {
    $self instvar audioDevice_
    set controller [$audioDevice_ get_controller]
    if { $controller == 0 } {
	return 0
    }
    return [$controller ntp_time]
}



#
# The AudioStream class, basically it is the sound card's abstraction
#

Class AudioStream -configuration {
    inputGain 32
    outputGain 180
    maxPlayout 6
    mikeAGCLevel 0
    speakerAGCLevel 0
    echoSuppressTime 400
}

#
# sets up the basic variables are then tries to find
# and open the sound card, then give it default settings.
#
AudioStream public init { session sampRate use16bitPCM useStereo {deviceName {}} } {
    $self instvar bufferPool_ session_ silenceThresh_ audioTest_ sampleRate_ use16bitPCM_ useStereo_

    set silenceThresh_ 20
    set audioTest_ none
    set session_ $session
    set sampleRate_ $sampRate
    set use16bitPCM_ $use16bitPCM
    set useStereo_ $useStereo

    $self compute_controller_defaults
    #
    # FIXME current behavior is that agent always opens the underlying
    # device.  The actual physical device may not be present or
    # might not open, but in any event, the under C++ device object
    # is created and initialized.
    #

    # FIXME - shouldn't session and AudioAgent share the same buffer pool?
    if ![info exists bufferPool_] {
	set bufferPool_ [new BufferPool/RTP]
	# $bufferPool_ srcid [$session_ get_local_srcid]
    }

    # try to open the device
    set devList [$self device_list]
    if { $devList == "" } {
	#FIXME
	$self fatal "no suitable audio device found."
    }

    if { $deviceName != "" } {
	set d $deviceName
    } else {
	foreach d $devList {
	    if { "$d" != "AF" } {
		break
	    } elseif [$self yesno useAF] {
		break
	    }
	}
    }
    $self open_device $d
    # choose a reasonable default
    $self select_format PCM 2
    # initially mute input/mike and unmute output/speaker
    $self set_input_mute 1
    $self set_output_mute 0
    $self set_output_gain 5
    if ![$self have_audio] {
	$self obtain
    }
}

AudioStream public get_controller { } {
    $self instvar controller_
    if [info exists controller_] {
	return $controller_
    }
    return 0
}

#
# close everything
#
AudioStream public destroy {} {
    $self instvar bufferPool_
    if [info exists bufferPool_] {
	delete $bufferPool_
    }
    $self close_device
}

#
# Compute the max playout delay used by the (C++) audio controller
# from the configuration option "maxPlayout".  Install the
# result in the AudioController class variable (so when we
# create the object instance, the C++ max_playout_ variable
# is appropriately initialized.
#
AudioStream private compute_controller_defaults {} {
    $self instvar sampleRate_ use16bitPCM_ useStereo_

	#FIXME compilation constants
	set AUDIO_SPS [expr $sampleRate_ * [expr 1 + $useStereo_]]
	set TALK_LEAD 4
	set TALK_TAIL 32
    #AUDIO_FRAMESIZE is the number of samples, not bytes
	set AUDIO_FRAMESIZE 160
	set SS_GRANULARITY 1440

	set v [expr [$self get_option maxPlayout] * $AUDIO_SPS]
	if [expr $v < ($TALK_LEAD + $TALK_TAIL + 2) * $AUDIO_FRAMESIZE] {
		set w [expr (($TALK_LEAD + $TALK_TAIL + 2) * \
			$AUDIO_FRAMESIZE + $AUDIO_SPS - 1) / $AUDIO_SPS]
		puts stderr "max playout delay $v too short - using $w sec"
		set v [expr ($TALK_LEAD + $TALK_TAIL + 2) * $AUDIO_FRAMESIZE]
	}
	set v [expr ($v + ($SS_GRANULARITY - 1)) / $SS_GRANULARITY]
	set v [expr $v * $SS_GRANULARITY / $AUDIO_FRAMESIZE]
	AudioController set max_playout_ $v
	AudioController set echo_suppress_time_ [expr \
		[$self get_option echoSuppressTime] / 20 * $AUDIO_FRAMESIZE]
}



#
# Set the audio format used by the underlying audio compression
# algorithm.  Note that this only affects outgoing audio.
# <i>fmt</i> is a string that represents the coding
# scheme and may be any of the values returned by
# the get_compression_formats method. (FIXME need to implement)
# <p>
# <i>blksPerPkt</i> specifies the number of audio blocks
# to include in each packet.  Typically 2 to 4 audio blocks are
# included in each packet.  Making this number larger decreases
# the per-packet network and system overhead, but increases
# latency since the audio sub-system has to wait longer before
# sending a packet.  Likewise, making it smaller increases interactive
# performance at the cost of performance overhead.
#
AudioStream public select_format { fmt blksPerPkt } {
	$self instvar encoder_ bufferPool_ session_ \
			controller_ blksPerPkt_
	if [info exists encoder_] {
		delete $encoder_
	}
	set encoder_ [new Module/AudioEncoder/$fmt]
	set blksPerPkt_ $blksPerPkt
	if [info exists controller_] {
		$controller_ encoder $encoder_
		$controller_ blocks-per-packet $blksPerPkt
	}
	if { "$encoder_" == "" } {
		return -1
	}
	$encoder_ target $session_
	$encoder_ buffer-pool $bufferPool_

	return 0
}


#
# Return a list of OTcl class that correspond to devices
# that are supported in this version of the mash platform.
#
AudioStream public device_list {} {
    if ![TclObject is-class Audio] {
	return ""
    }
    set temp [Audio info subclass]
    set ix [lsearch -exact $temp Audio/RealAudioVirtualDevice]
    if {$ix >= 0} {
	return [lreplace $temp $ix $ix]
    } else {
	return $temp
    }
}

#
# Arrange for the audio agent to activate the transducer object named
# by <i>o</i> whenenter there is input or output, according to
# <i>which</i> (either "input" or "output").
# 
AudioStream public bind_transducer { which o } {
    $self instvar meter_ controller_
    set meter_($which) $o
    if [info exists controller_] {
	$controller_ $which-meter $o
    }
}


#
# Create an audio device to manage the underlying hardware codec
# and deallocate state that depends on the old device (if it
# was open).  <i>dev</i> is the OTcl class name of the Audio
# device that is created.
#
AudioStream private open_device dev {
	$self instvar audio_ meter_ controller_ silenceThresh_ sampleRate_ use16bitPCM_ useStereo_
	if [info exists audio_] {
		delete $audio_
		unset audio_
	}
	if [info exists controller_] {
		delete $controller_
		unset controller_
	}
	set audio_ [new $dev]
	if { $dev == "Audio/OSS" } {
	    $audio_ set_sample_rate $sampleRate_
	    if { $use16bitPCM_ == 1 } {
		$audio_ useRaw16PCM
	    }
	    if { $useStereo_ == 1 } {
		puts "setting card to do stereo sound"
		$audio_ useStereo
	    }
	}
	$self instvar gain_
	#FIXME
	set names [$self get_input_ports]
	foreach port $names {
		if {[$self get_option $port\Gain]!={}} {
			set gain_($port) [$self get_option $port\Gain]
		} else {
			set gain_($port) [$self get_option inputGain]
		}
	}
	set names [$self get_output_ports]
	foreach port $names {
		if {[$self get_option $port\Gain]!={}} {
			set gain_($port) [$self get_option $port\Gain]
		} else {
			set gain_($port) [$self get_option outputGain]
		}
		$self set_speakerphone $port [$self get_option $port\Mode]
	}

	#FIXME
	$self instvar port_
	set port_(input) ""
	set port_(output) ""
}

#
# Create, install, and initialize the AudioController object.  This
# operation must be deferred until after the audio device has been
# ``obtained'' and opened because we need to determine whether the
# underlying hardware operates in full- or half-duplex mode and create
# a controller object that is compatible with this mode.
#
AudioStream private install_controller {} {
	$self instvar audio_ encoder_ blksPerPkt_ silenceThresh_ meter_ \
		controller_
	if [$audio_ set duplex_] {
		set duplex FullDuplex
	} else {
		set duplex HalfDuplex
		#
		# If we're half duplex, try obtaining the device
		# (i.e., actually opening it) to see if it's full
		# duplex.  Or, if an user option says to force
		# the use of full duplex then do that.
		#
		if ![$self have_audio] {
			$self obtain 0
		}
		if { [$self yesno forceFullDuplex] || [$audio_ set duplex_] } {
			set duplex FullDuplex
		}
	}
	set controller_ [new AudioController/$duplex]
	$controller_ audio $audio_
	if [info exists meter_(input)] {
		$controller_ input-meter $meter_(input)
	}
	if [info exists meter_(output)] {
		$controller_ output-meter $meter_(output)
	}
	$controller_ silence-thresh $silenceThresh_
	if [info exists encoder_] {
		$controller_ encoder $encoder_
		$controller_ blocks-per-packet $blksPerPkt_
	}
	$controller_ agc-input [$self get_option mikeAGCLevel]
	$controller_ agc-output [$self get_option speakerAGCLevel]
	$controller_ silence-thresh [$self get_option silenceThresh]
}

#
# Attempt to open and intialize the underlying audio hardware.
# The creation of an AudioAgent does not immediately mean that
# the underlying audio hardware is opened and initialized because
# multiple applications might want to simultaneously access the
# device but many such devices cannot be shared because of
# the operating system's contraints on the API.  Thus, we have
# explicit methods for obtaining and releasing the underlying
# hardware resources.  After <i>obtain</i> is called, the <i>haveaudio</i>
# method can be queried to see if the device was successfully
# opened.  Once obtained, the device can be released with the
# AudioAgent::release.
#
AudioStream public obtain { {should_install_controller 1} } {
	$self instvar audio_ controller_
	$audio_ obtain

	# check if a controller exists; make sure that the controller
	# is of the correct "duplex" mode
	if [info exists controller_] {
		set cl [$controller_ info class]
		if [string match *FullDuplex* $cl] {
			set duplex 1
		} else {
			set duplex 0
		}

		if { [$audio_ set duplex_] != $duplex } {
			delete $controller_
			unset controller_
		}
	}

	if { ![info exists controller_] && $should_install_controller } {
		$self install_controller
	}
}

#
# Release the underlying audio hardware without deallocating
# the AudioAgent object.  This allow
# The creation of an AudioAgent does not immediately mean that
# the underlying audio hardware is opened and initialized because
# multiple applications might want to simultaneously access the
# device but many such devices cannot be shared because of
# the operating system's contraints on the API.  Thus, we have
# explicit methods for obtaining and releasing the underlying
# hardware resources.  After <i>obtain</i> is called, the <i>haveaudio</i>
# method can be queried to see if the device was successfully
# opened.  Once obtained, the device can be released with the
# AudioAgent::release.
#
AudioStream public release {} {
	# audio_ represents the audio device
	[$self set audio_] release
}

#
# Set the threshold for the silence suppression algorithm
# used by the AudioController to <i>thresh</i>.
# FIXME: need to define units.  Should be probably be dB.
#
AudioStream public set_silence_thresh thresh {
	$self instvar silenceThresh_ controller_
	set silenceThresh_ $thresh
	if [info exists controller_] {
		$controller_ silence-thresh $silenceThresh_
	}
}

#
# Return true iff the AudioAgent has opened and currently ``owns''
# the underlying hardware audio device.
#
AudioStream public have_audio {} {
	$self instvar audio_
	if [info exists audio_] {
		return [$audio_ have]
	}
	return 0
}

#
# Set the mute attribute on the input port of the underlying
# audio device (i.e., the mike, linein, etc) as indicated
# by <i>val</i>.  When muted, audio samples from the input
# device are ignored and no network traffic is generated.
#
AudioStream public set_input_mute val {
	$self instvar audio_
	$audio_ set_input_mute $val
}

#
# Set the mute attribute on the output port of the underlying
# audio device (i.e., the speaker, headphones, etc) as indicated
# by <i>val</i>.  When muted, audio packets from the network
# are processed but not output to the audio hardware.
#
AudioStream public set_output_mute val {
	$self instvar audio_
	$audio_ set_output_mute $val
}

#
# Return the list of available input ports supported
# by the underlying audio hardware.  Each name in the
# list is unique so names can be used as keys into a table.
# The list consists of a sequence of names,
# where the name is the nick name of the port
# (e.g., "mike").
#
AudioStream public get_input_ports {} {
	$self instvar audio_
	return [string tolower [$audio_ get_input_ports]]
}

#
# Return the list of available output ports supported
# by the underlying audio hardware.  Each name in the
# list is unique so names can be used as keys into a table.
# The list consists of a sequence of names,
# where the name is the nick name of the port
# (e.g., "speaker").
#
AudioStream public get_output_ports {} {
	$self instvar audio_
	return [string tolower [$audio_ get_output_ports]]
}

#
# Return true iff the underlying audio hardware supports
# only half-duplex operations, meaning it cannot simultaneously
# play and record audio samples (and consequently, can only
# be used in a walkie-talkie/CB type mode).
#
AudioStream public is_halfduplex {} {
	$self instvar audio_
	return [expr ![$audio_ set duplex_]]
}

#
# Return the current input port in use by the underlying
# audio hardware.
#
AudioStream public get_input_portno { } {
	$self instvar audio_
	return [$audio_ get_input_port]
}

#
# Return the current output port in use by the underlying
# audio hardware.
#
AudioStream public get_output_portno { } {
	$self instvar audio_
	return [$audio_ get_output_port]
}

#
# Set the speakerphone mode of the port named by <i>port</i>
# to the mode specified by <i>mode</i>.
# Sets the speakerphone attribute as indicated
# by <i>mode</i>, which can be one of:
# <ul>
# <li> fullduplex,
# <li> mikemutesnet, or
# <li> netmutesmike.
# </ul>
#
AudioStream public set_speakerphone { port mode } {
	$self instvar speakerphone_ port_
	set speakerphone_($port) $mode
	if { [info exists port_(output)] && $port == $port_(output) } {
		$self instvar audio_
		$audio_ set_speakerphone $mode
	}
}

#
# Perform an audio test as indicated by <i>type</i>, which
# may be one of:
# <ul>
# <li> none
# <li> loopback
# <li> low
# <li> med, or
# <li> high.
# </ul>
# If <i>type</i> is low, med, or high, then a pure sine-wave test-tone
# is mixed into the audio output, where the test signal's amplititude
# is either -6dBm, 0dBm, or full scale.  If <i>type</i> is ``loopback'',
# then any test tone previously selected is disabled, and instead,
# the audio signal is loopbed back from the input to the output
# in software (note that this can cause feedback if the acoustic
# coupling between the input and output is high enough).  Finally,
# when <i>type</i> is none, the underlying audio device behaves
# as normal with no test tones or looped signal.
#
AudioStream public audio_test type {
	$self instvar audioTest_ controller_
	$self set audioTest_ $type
	if [info exists controller_] {
		if { $type == "loopback" } {
			$controller_ test_tone none
			$controller_ loopback 1
		} else {
			$controller_ test_tone $type
			$controller_ loopback 0
		}
	}
}

AudioStream private port_name_to_num { which name } {
	set L [$self get_$which\_ports]
	return [lsearch -exact $L $name]
}

#
# Set the input port for the underlying audio codec capture
# path to <i>port</i>.  The port specified must be one of the
# names in the list returned by Audio::get_input_ports.
# Otherwise, results are undefined.
#
AudioStream public set_input_port port {
	$self instvar audio_ port_ gain_ speakerphone_
	set port_(input) $port
	$audio_ set_input_port [$self port_name_to_num input $port]
	#
	# Reset the gain level since we want to keep a different
	# level for each port type.
	#
	$self set_input_gain $gain_($port)
}

#
# Set the output port for the underlying audio codec capture
# path to <i>port</i>.  The port specified must be one of the
# names in the list returned by Audio::get_output_ports.
# Otherwise, results are undefined.
#
AudioStream public set_output_port port {
	$self instvar audio_ port_ gain_ speakerphone_
	set port_(output) $port
	$audio_ set_output_port [$self port_name_to_num output $port]
	#
	# Reset the gain level since we want to keep a different
	# level for each port type.
	#
	$self set_output_gain $gain_($port)
	$self set_speakerphone $port $speakerphone_($port)
}

#
# Set the input gain on the currently selected port of the underlying
# audio codec capture path to <i>gain</i>.
# This level is a linear gain
# factor from 0 to 255. FIXME should change this?
# Note that the gain on each port is maintained separately,
# so if the selected port is changed the gain of the underlying
# audio hardware is updated automatically.
#
AudioStream public set_input_gain gain {
	$self instvar audio_ port_ gain_
	set gain_($port_(input)) $gain
	return [$audio_ set_input_gain $gain]
}

#
# Set the output gain on the currently selected port of the underlying
# audio codec capture path to <i>gain</i>.
# This level is a linear gain
# factor from 0 to 255. FIXME should change this?
# Note that the gain on each port is maintained separately,
# so if the selected port is changed the gain of the underlying
# audio hardware is updated automatically.
#
AudioStream public set_output_gain gain {
	$self instvar audio_ port_ gain_
	set gain_($port_(output)) $gain
	return [$audio_ set_output_gain $gain]
}

#
# Return the input gain for the currently selected port of the underlying
# audio codec capture path.
#
AudioStream public get_input_gain {} {
	$self instvar port_ gain_
	return $gain_($port_(input))
}

#
# Return the output gain for the currently selected port of the underlying
# audio codec capture path.
#
AudioStream public get_output_gain {} {
	$self instvar port_ gain_
	return $gain_($port_(output))
}

#
# Close and deallocate the underlying Audio device and
# controller object.
#
AudioStream private close_device {} {
    $self instvar audio_ controller_
	if [info exists audio_] {
		delete $audio_
		unset audio_
		delete $controller_
		unset controller_
	}
}

#
# Return true iff the underlying audio session has incurred
# ``activity'' since the last call to AudioAgent::clear_active.
# In this context, activity implies that either audio packets were
# sent over the network or a test tone was in progress.
# <p>
# This hook might be used, for instance, by an agent that
# orchestrates access to non-shared audio hardware.
#
AudioStream public is_active {} {
	$self instvar controller_ audioTest_
	if [info exists controller_] {
		if { $audioTest_ != "none" } {
			return 1
		}
		return [$controller_ active]
	}
	return 0
}

#
# Reset the ``activity'' trigger so that AudioAgent::is_active
# will return false until new activity occurs in the
# underlying audio session
# In this context, activity implies that either audio packets were
# sent over the network or a test tone was in progress.
#
AudioStream public clear_active {} {
	$self instvar controller_
	if [info exists controller_] {
		$controller_ active 0
	}
}

# changes the sample rate of the device (must be called before obtain)
AudioStream public set_sample_rate { sr } {
    $self instvar sampleRate_
    set sampleRate_ $sr
}

# changes the bit depth of the stream (must be called before obtain)
AudioStream public use_16_bit_raw_PCM {} {
    $self instvar use16bitPCM_
    set use16bitPCM_ 1
}


# a class for 16 bit raw PCM audio

Class AudioAgent16 -superclass AudioAgent

AudioAgent16 public init { app spec sampleRate use16 isStereo devName {callback {}} } {
    $self instvar sampRate use16bit useStereo
#    set sampRate 44100
    set sampRate $sampleRate
#    set use16bit 1
    set use16bit $use16
#    set useStereo 0
    set useStereo $isStereo
#    set deviceName "Audio/OSS"
    set deviceName $devName

    $self next $app $spec $callback
}
