# ui-vat.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/msp/ui-vat.tcl,v 1.22 2002/02/03 04:28:01 lim Exp $


import VatUI AddressBlock AudioAgent

#
# The audio component of the user interface for the MSP (mash streaming player).
# Status: alpha
# Author: Suchitra Raman

# Class VatApplication -superclass RTPApplication


# Set up the vat user interface and start mega if necessary
MSP_Application instproc start_vat argv {
	$self instvar ui_ vat_
        $self instvar glob_chan_

	set o [$self options]

	$self init_vat_args
	#$self parse_args $argv
	set argv [$o parse_args $argv]

	$self parse_hostspec $argv

	$self init_local


	set spec [$self get_option defaultHostSpec]
	set pspec [split $spec /]
	set mspec [lindex $pspec 0]/[lindex $pspec 1]/[lindex $pspec 3]

        $self add_option audioSessionSpec $mspec
        if {[$self get_option megaVideoSession] != "" } {
	       set spec ""
	}
	set vat_(agent) [new AudioAgent $self $spec "$self reset_audio"]

	if { $spec != "" } {
		# vat doesn't want traffic looped back (like vic does)
		#$vat_(agent) set-loopback 0
		$vat_(agent) app_loopback 0
	}

	$self init_confbus

	global mash
	if { ![info exists mash(environ)] || $mash(environ)!="mplug" } {
	    wm withdraw .
	}
	update idletasks
	global minwidth minheight iconPrefix
	set minwidth [winfo reqwidth .]
	set minheight [winfo reqheight .]
	wm minsize . $minwidth $minheight
	$self add_option audioFormat PCM2
#	frame .main.vat
	set vat_(ui) [new VatUI $ui_(main).av.vat $glob_chan_ $vat_(agent) "$self exit_vat" $spec]
#	pack .top -expand 1 -fill both

	update idletasks
	if { ![info exists mash(environ)] || $mash(environ)!="mplug" } {
	    wm deiconify .
	}
	$vat_(agent) attach $vat_(ui)

	# set the window & icon title from the conference name
	set prefix [$self get_option iconPrefix]
	if { $spec == "" } {
		set conf "Contacting MeGa..."
	} else {
		set conf [$self get_option conferenceName]
	}
	$vat_(ui) window-title [$self resource iconPrefix] $conf

	$self user_hook
}

# Data address has changed, so reset vat
MSP_Application instproc reset_vat argv {
        $self instvar vat_
        $self parse_hostspec $argv

        set spec [$self get_option defaultHostSpec]
        set pspec [split $spec /]
	set mspec [lindex $pspec 0]/[lindex $pspec 1]/[lindex $pspec 3]

        $self add_option audioSessionSpec $mspec
	if { [$self get_option megaVideoSession] != "" } {
	    # MARS playback addr has changed, so need to repoint audio gw
	    $vat_(agent) reset_mega
	} else {
	    $vat_(agent) reset_spec $spec
	}
}


# Called from RTPAgent
MSP_Application instproc reset_audio {ab} {
    $self instvar vat_

    if [info exists vat_(ui)] {
	$vat_(ui) reset
    }
}

#
MSP_Application instproc exit_vat {} {
	$self instvar vat_
	# FIXME: should delete everything else as well
	delete $vat_(ui)
	# FIXME: note this exits the application!
	$vat_(agent) shutdown

	# should not be here
	exit 0
}

#
MSP_Application instproc init_vat_args {} {
	$self instvar vat_arg_resource_
	set vat_arg_resource_(-B) maxbw
	set vat_arg_resource_(-C) conferenceName
	set vat_arg_resource_(-c) dither
	set vat_arg_resource_(-D) device
	set vat_arg_resource_(-f) audioFormat
	set vat_arg_resource_(-F) maxfps
	set vat_arg_resource_(-I) confBusChannel
	set vat_arg_resource_(-K) sessionKey
	set vat_arg_resource_(-M) colorFile
	set vat_arg_resource_(-m) mtu
	set vat_arg_resource_(-n) network
	set vat_arg_resource_(-o) outfile
	set vat_arg_resource_(-q) jpegQfactor
	set vat_arg_resource_(-t) defaultTTL
	set vat_arg_resource_(-T) softJPEGthresh
	set vat_arg_resource_(-U) stampInterval
	set vat_arg_resource_(-V) visual

	set vat_arg_resource_(-confid) confid

	# MeGa resources
	set vat_arg_resource_(-rport) megaRecvAudioPort
	set vat_arg_resource_(-ofmt) megaAudioFormat
	set vat_arg_resource_(-usemega) megaVideoSession
	set vat_arg_resource_(-megactrl) megaAudioCtrl
	set vat_arg_resource_(-sspec) audioSessionSpec
	set vat_arg_resource_(-maxsbw) maxAudioSessionBW
	set vat_arg_resource_(-sbw) audioSessionBW
}

