# ui-menu.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1993-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import WidgetClass Configuration
WidgetClass transparent_gif
import MBLogo_Icon StackTrace DbgInfoWindow MBPres KeyEditor

#
# The menubar along the top of the mediaboard... <br>
#   File Edit View Help        Logo
#
Class MBMenu -configuration {
	showOwnerTip 1
	# show  owner tip when items are being manipulated
	showOwnerAsDrawn 1
	followActive 1
}

MBMenu proc make_menu { parent menuList } {
        foreach {menuName label} $menuList {
                set menuBut $parent.$menuName
                set menu $menuBut.menu
                menubutton $menuBut -menu $menu -text $label -underline 0
                pack $menuBut -side left
                menu $menu -tearoff false
        }
}

# <!FIXME: this function should go into MBPageMgr >
#
MBMenu instproc create_new_page {{page_name {}}} {
	$self instvar mbui_
	[[$mbui_ mgr] page_manager] create_new_page
}

#
MBMenu instproc init {ui fr mgr exitCmd args} {
    $self instvar mbui_ mgr_
    set mbui_ $ui
    set mgr_ $mgr

    set menubar [eval frame $fr.menu $args]
    set logoF [frame $fr.info]
    pack $logoF -side right -anchor e

    set logofont [$self get_option logofont]
    # image create photo mblogo -file "c:/temp/mb.gif"

    set logoImageL [button $logoF.imgL -image MBLogo_Icon \
		    -highlightthickness 0 -relief flat -command {
	    set p [new StackTrace]
	    global errorInfo
	    $p open $errorInfo
    }]
    pack $logoImageL -side right -fill y -anchor s -expand false

    set menuList { file "File" edit "Edit" view "View" help "Help"}
    MBMenu make_menu $menubar $menuList

    # FILE
    set filemenu $menubar.file.menu
    $filemenu add command -label Save -underline 0 \
		    -command "$self save"

    $filemenu add command -label "Save as PostScript"  -underline 9 \
		-command "$self postscript"

    $filemenu add command -label Load -underline 0 \
		    -command "$self load"

    if { $exitCmd != {} } {
	    $filemenu add command -label Quit -underline 0 \
			    -command "$exitCmd"
    }


    # EDIT

    # add all these entries to the list that is to be disabled with
    # set to readonly mode
    $self instvar readonlyList_
    set editmenu $menubar.edit.menu
    set i 0
    $editmenu add command -label "Erase Last" -underline 0 \
		-command "$self erase_last"
    lappend readonlyList_ [list $editmenu $i]
    incr i
    $editmenu add command -label "Unerase" -underline 0 \
		-command "$self unerase"
    lappend readonlyList_ [list $editmenu $i]
    incr i
    $editmenu add command -label "New Page" -underline 0 \
		-command "$self insert_page"
    lappend readonlyList_ [list $editmenu $i]
    incr i
    $editmenu add command -label "Import..." -underline 0 \
		-command "$self import_ext"
    lappend readonlyList_ [list $editmenu $i]


    # VIEW
    set viewmenu $menubar.view.menu
    # don't view source list by default

    $self tkvar showSrcList_
    set srcList [$mbui_ set srcList_]

    $viewmenu add checkbutton -label "Members..." -underline 0 \
		-variable [$self tkvarname showSrcList_] \
		-command "$srcList toggle_window \
		\[set [$self tkvarname showSrcList_]\]"

    # install callback
    $srcList add_callback dismiss "set [$self tkvarname showSrcList_] 0"
    $srcList add_callback followAny "set [$self tkvarname follow_active_]"

    # follow_active on by default
    $self tkvar follow_active_
    set follow_active_ [$self get_option followActive]
    $srcList set_followAny $follow_active_

    $self tkvar browseTime_
    $viewmenu add checkbutton -label "Past Activity..." -underline 0 \
		    -variable [$self tkvarname browseTime_] \
		    -command "$mbui_ browseTime [$self tkvarname browseTime_]"

    $viewmenu add command -label "Session info..." \
            -underline 8 -command "$self disp-sess-info"

    # puts "follow active set to $follow_active_"
    $viewmenu add checkbutton -label "Follows activity" \
		    -underline 0 \
		    -variable [$self tkvarname follow_active_]

    set pageList [[[$self set mbui_] set pageNavPanel_] set pageList_]
    $viewmenu add cascade -label "Page" \
            -menu [$pageList get_copy $viewmenu] -underline 0

    set tipOptionMenu $viewmenu.tipOptions
    $viewmenu add cascade -label "Tips" \
		    -menu $tipOptionMenu -underline 0

    menu $tipOptionMenu -tearoff 0

    $self tkvar showOwnerTip_
    $tipOptionMenu add checkbutton -label "under cursor" -underline 0 \
		    -variable [$self tkvarname showOwnerTip_] \
		    -command "$self show_owner_tip"
    set showOwnerTip_ [$self get_option showOwnerTip]

    $self tkvar showOwnerAsDrawn_
    $tipOptionMenu add checkbutton -label "when drawn" -underline 0 \
		    -variable [$self tkvarname showOwnerAsDrawn_] \
		    -command "$self show_owner_as_drawn"
    set showOwnerAsDrawn_ [$self get_option showOwnerAsDrawn]

    set optionmenu $viewmenu.option
    $viewmenu add cascade -label "Options" \
            -menu $optionmenu \
            -underline 0

    menu $optionmenu -tearoff 0

    $self tkvar enable_debug_
    set enable_debug_ 0
    set dbgVarName [$self tkvarname enable_debug_]
    set debugDlg [$mbui_ set debug_]
    $optionmenu add checkbutton -label "simulate pkt drop" -underline 0 \
		    -variable $dbgVarName \
		    -command "[$mbui_ set debug_] change_state \
		    \[set $dbgVarName\]"
    $debugDlg add_callback disable_drop "set [$self tkvarname enable_debug_] 0"


    $self tkvar enable_trace_
    set enable_trace_ 0
    $optionmenu add command -label "toggle trace window" -underline 0 \
		    -command "[MTrace set mtrace] toggle_window"
    $optionmenu add checkbutton -label "status bar on top" \
		    -variable [$mbui_ tkvarname statusbarOnTop_] \
		    -command "$mbui_ redraw_statusbar"

    set dbgmenu $viewmenu
    set dumpm $dbgmenu.dumpm
    $dbgmenu add cascade -label "Debug Info" -menu $dumpm -underline 0
    menu $dumpm -tearoff 0
    set sender [[$mbui_ mgr] sender]
    $dumpm add command -label "TimeStamps" -underline 0 \
		    -command "$self dump_ts"
    set pageMgr [[$mbui_ mgr] page_manager]
    $dumpm add command -label "Canvas" -underline 0 \
		    -command "$self dump_canv"

    set helpmenu $menubar.help.menu
    $helpmenu add command -label About -underline 0 \
            -command "$self about"

    pack $menubar -side left -fill y -anchor w -expand true
    return $menubar
}

#
MBMenu instproc disp-sess-info {} {
        $self instvar mgr_ sessDlg_

	if ![info exists sessDlg_] {
		set sessDlg_ [MBSessionDlg .mbSessDlg -mgr $mgr_ \
				-title "MediaBoard Session Information" \
				-name [[$mgr_ local_src] cname]]
	}
	wm deiconify $sessDlg_
}

MBMenu instproc about {} {
	append msg "MediaBoard \n" \
			"Version [version]\n" \
			"\n" \
			"MASH Group \n" \
			"University of Califonia, Berkeley"

	set msgBox [Dialog transient MessageBox -title "About MediaBoard" \
			-text $msg -type ok]
}

MBMenu instproc followActivePage {} {
	$self tkvar follow_active_
	return $follow_active_
}

MBMenu instproc insert_page {} {
	$self instvar mbui_
	set new_pgid [$self create_new_page]
	set pageMgr [[$mbui_ mgr] page_manager]
	$pageMgr switch_page_later $new_pgid
}

MBMenu instproc import_ext {} {
	$self instvar mbui_
	set toolbar [$mbui_ set toolbar_]
	# interrupt the current tool
	$toolbar deactivate_tool [$toolbar current_tool]
	[$toolbar tool import] activate [[[$mbui_ mgr] page_manager] current_page]
}

#
MBMenu instproc tool {toolname} {
	return [[[$self set mbui_] set toolbar_] tool $toolname]
}

MBMenu instproc paste {} {
	$self instvar mbui_
	set c  [[[$mbui_ mgr] page_manager] current_canvas]
	set textTool [$self tool text]
	mtrace trcMB "texttool: $textTool"
	# put it on the top left corner
	$textTool paste $c [$c canvasxy 1.0 1.0]
}

# change settings of show owner under cursor
MBMenu instproc show_owner_tip {} {
	$self tkvar showOwnerTip_
	$self instvar mbui_
#	puts "showOwnerTip_ is $showOwnerTip_"
	[[[$mbui_ mgr] page_manager] current_canvas] enable_tip $showOwnerTip_
}

# change settings of showing the owner as the items are being displayed
MBMenu instproc show_owner_as_drawn {} {
	$self tkvar showOwnerAsDrawn_
	$self instvar mbui_
	$mbui_ enable_tip_as_drawn $showOwnerAsDrawn_
}

MBMenu instproc showOwnerVal {} {
	$self tkvar showOwnerTip_
	return $showOwnerTip_
}

MBMenu instproc unerase {} {
	set ueTool [$self tool unerase]
	$self instvar mbui_
	$ueTool unerase	[[[$mbui_ mgr] page_manager] current_page]
}

MBMenu instproc erase_last {} {
	$self instvar mbui_
	set eTool [$self tool erase]
	$eTool erase_last [[[$mbui_ mgr] page_manager] current_page]
}

MBMenu instproc readonly {on} {
	$self instvar readonlyList_
	if {$on} {
		foreach item $readonlyList_ {
			set widget [lindex $item 0]
			set index [lindex $item 1]
			eval $widget entryconfigure $index -state disabled
		}
	} else {
		foreach item $readonlyList_ {
			set widget [lindex $item 0]
			set index [lindex $item 1]
			eval $widget entryconfigure $index -state normal
		}
	}
}

#
# prints the current page
#
MBMenu instproc postscript {} {
	$self instvar mbui_
	if {[[[$mbui_ mgr] page_manager] current_page] != {}} {
		[$mbui_ printUI] show
	}
}

#
MBMenu instproc load {} {
	$self instvar mbpres_ mbui_
	if ![info exists mbpres_] {
		set filename [Dialog transient FileDialog \
				-title "Choose file to load from" \
				-type open]
		set mbpres_ [new MBPres [$mbui_ mgr] $filename]
	}
	$mbpres_ load
}

MBMenu instproc save {} {
	$self instvar mbui_
	set canv [[[$mbui_ mgr] page_manager] current_canvas]
	MBPres save_canvas $canv "pres-out.mb"
}

MBMenu instproc dump_ts {} {
	$self instvar mbui_
	set sender [[$mbui_ mgr] sender]
	if ![catch {$sender dump timestamps} result] {
		if {$result != {}} {
			new DbgInfoWindow "timestamps" $result
		}
	}
}

MBMenu instproc dump_canv {} {
	$self instvar mbui_
	set sender [[$mbui_ mgr] sender]
	if ![catch {$sender dump canvas} result] {
		if {$result != {}} {
			append result [DumpCanvas [$pageMgr \
					current_canvas]]
			new DbgInfoWindow "timestamps" $result
		}
	}
}

# Session Information Dialog
WidgetClass MBSessionDlg -superclass Dialog -configspec {
	{ -mgr mgr Mgr "" config_mgr cget_mgr }
	{ -name name Name "" config_name cget_name }
}

MBSessionDlg private build_widget { path } {
	$self set path_ $path
	set f [frame $path.topframe -bd 2 -relief flat]
	pack $f -fill both -expand 1 -side top

	set infoLabel [label $f.ilabel -text "Network Information" -font \
			[$self get_option medfont]]
	pack $infoLabel -fill x -side top

	set ef [frame $path.entryframe -bd 2 -relief sunken]
	$self set_subwidget entryframe $ef
	pack $ef -fill both -expand 1 -side top

	set ft [frame $path.topframe.infoframe -bd 2 -relief sunken]
	label $ft.text -justify left
	$self set_subwidget text $ft.text
	pack $ft.text -side top -anchor w -expand 1 -fill both
	pack $ft -side top -fill both

	set configLabel [label $f.clabel -text "Configurations" -font \
			[$self get_option medfont]]
	pack $configLabel -fill x -side top

	$self instvar nameEntry_

	set nf [frame $ef.nf]
	set ne [entry $nf.name -font [$self get_option smallfont]]
	set nameEntry_ $ne
	set nl [label $nf.label -font [$self get_option smallfont] \
			-text "Name: "]

	bind $ne <Return> "$self update_name \[%W get\]"
	bind $ne <Escape> "$self configure -name \[set [$self tkvarname name_]\]; break"
	bind $ne <FocusOut> "$self update_name \[%W get\]"
	pack $nf -side top -fill x -expand 1 -padx 1 -pady 1
	pack $nl -side left -expand 0
	pack $ne -side left -fill x -anchor w -expand 1 -padx 1

	set bf [frame $path.bframe -bd 1 -relief flat]
	ImageTextButton $bf.ok -underline 0 -text "Ok" \
			-image Icons(check) -orient horizontal \
			-command "$self dismiss"

	pack $bf.ok -expand 0 -pady 2
	pack $bf -fill x -expand 0 -side bottom	-anchor s
}

MBSessionDlg private config_name {option name} {
	$self tkvar name_
	set name_ $name
	$self instvar nameEntry_
	$nameEntry_ del 0 end
	$nameEntry_ insert 0 $name_
}

MBSessionDlg private cget_name {name} {
	$self tkvar name_
	return $name_
}

MBSessionDlg private update_name {name} {
	$self instvar mgr_
	$mgr_ update_name $name
}

MBSessionDlg private config_mgr {opt mgr} {
	if {$mgr == {}} {
		return
	}
	$self instvar mgr_
	set mgr_ $mgr
	$self subwidget text configure -text [$self get_sessionInfo]
	set t [$self subwidget entryframe]
	$self instvar ke_
	if [info exists ke_] {
		delete $ke_
	}
	set ke_ [new KeyEditor $t [[$mgr session] get_agent]]
	pack $t.key -side bottom -fill x -anchor w -padx 1
}

MBSessionDlg private cget_mgr {} {
	return [$self set mgr_]
}

MBSessionDlg private get_sessionInfo {} {
	$self instvar mgr_

	set dn [[$mgr_ session] data-net]
	set cn [[$mgr_ session] ctrl-net]

	append msg      "Session address: "   [$dn addr]  "\n" \
			"Data port: "         [$dn sport] "\n" \
			"Control port: "      [$cn sport] "\n" \
			"Session TTL: "       [$dn ttl]   "\n" \
			"Session interface: " [$dn interface]
	return $msg
}

MBSessionDlg private dismiss { } {
	$self instvar nameEntry_ path_
	if {[$nameEntry_ get] != [$self cget -name]} {
		$self update_name [$nameEntry_ get]
	}
	wm withdraw $path_
	raise $path_
}

