/*
 * source-srm.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

// 	$Id: source-srm.cc,v 1.8 2002/02/03 04:16:51 lim Exp $

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "sys-time.h"
#include "source.h"
#include "inet.h"
#include "tclcl.h"
#include "ntp-time.h"

#include "appmgr-srm.h"

#define SHASH(a) ((int)((((a) >> 20) ^ ((a) >> 10) ^ (a)) & (SOURCE_HASH-1)))

/*FIXME*/
SRM_PacketHandler::~SRM_PacketHandler()
{
}


static class SRM_SourceClass : public TclClass {
public:
    SRM_SourceClass() : TclClass("Source/SRM") {}
    TclObject* create(int /*argc*/, const char*const* argv) {
        // use base 16!
	srm_src sid;
        sid.ss_uid  = strtoul(argv[4], (char **)NULL, 16);
	sid.ss_addr = strtoul(argv[5], (char **)NULL, 16);
	return (new SRM_Source(sid));
    }
} srm_source_class;



SRM_Source::SRM_Source(const srm_src &sid)
    : TclObject(),
      hlink_(0),
      handler_(0),
      id_(sid),
      delay_(10.00),
      lts_(0),
      cname_(NULL)
/*
 * cname is set explicitly from within Tcl later for a local source
 * or by the manager when a SDES packet is received
 */

{
    lts_done_.tv_sec = 0;
    lts_done_.tv_usec = 0;
    /*
     * Any time a new source is created the app_mgr has to be informed to
     *  provide a packet handler.
     */
}


SRM_Source::~SRM_Source()
{
    Tcl::instance().evalf("unregister %s", TclObject::name());
    delete [] cname_;
}


int
SRM_Source::command(int argc, const char*const* argv)
{
    Tcl& tcl = Tcl::instance();
    char* wrk = tcl.buffer();

    if (argc == 2) {
	/*if (strcmp(argv[1], "addr") == 0) {
	    // InetNtoa returns network byte order, we store in host byte order
	    strcpy(wrk, InetNtoa(addr_));
	    tcl.result(wrk);
	    return (TCL_OK);
	}
	if (strcmp(argv[1], "addr-hex") == 0) {
	    sprintf(wrk, "%lx", (u_long)addr_);
	    tcl.result(wrk);
	    return (TCL_OK);
	}
	if (strcmp(argv[1], "uid") == 0) {
	    sprintf(wrk, "%lu", (u_long)uid_);
	    tcl.result(wrk);
	    return (TCL_OK);
	}*/
	if (strcmp(argv[1], "srcid") == 0) {
	    sprintf(wrk, "%lx@%lx", (u_long)id_.ss_uid, (u_long)id_.ss_addr);
	    tcl.result(wrk);
	    return (TCL_OK);
	}
	if (strcmp(argv[1], "cname") == 0) {
	    if (!cname_)
		sprintf(wrk, "%u @ %s", id_.ss_uid, intoa(id_.ss_addr));
	    else
		sprintf(wrk, "%s", cname_);
	    tcl.result(wrk);
	    return (TCL_OK);
	}
    } else if (argc == 3) {
	if (strcmp(argv[1], "handler") == 0) {
	    const char* o = argv[2];
	    if (*o == 0)
		handler_ = 0;
	    else
		handler_ = (SRM_PacketHandler*)TclObject::lookup(o);
	    return (TCL_OK);
	}
	// Set the cname using a Tcl command
	if (strcmp(argv[1], "cname") == 0) {
	    cname(argv[2]);
	    return (TCL_OK);
	}


	if (strcmp(argv[1], "cname_update")==0) {
	    // this is the default handler for any UI updates that need to take
	    // place when the cname changes
	    //
	    // application OTcl code can redefine this method to do its own
	    // thing
	    return (TCL_OK);
	}

	/*if (strcmp(argv[1], "addr") == 0) {
	    addr_ = atoi(argv[2]);
	    return (TCL_OK);
	}
	if (strcmp(argv[1], "uid") == 0) {
	    uid_ = atoi(argv[2]);
	    return (TCL_OK);
	}*/
    }
    return (TclObject::command(argc, argv));
}

// Set the cname of the SRM source. Call this from Tcl using the
// command interface, or call this from the network objects when source
// info gets updated.

void
SRM_Source::cname(const char *str) {
    int len = strlen(str);
    delete [] cname_;
    cname_ = new char[len+1];
    strcpy(cname_, str);
    Tcl& tcl = Tcl::instance();

    MTrace(trcSRM|trcVerbose, ("cname set to: %s", cname_));

    tcl.evalf("%s cname_update {%s}", name(), str);

    MTrace(trcSRM|trcVerbose, ("returned from update"));
}


static class SRM_SourceManagerClass : public TclClass {
public:
    SRM_SourceManagerClass() : TclClass("SourceManager/SRM") {}
    TclObject* create(int /*argc*/, const char*const* /*argv*/) {
	return (new SRM_SourceManager);
    }
} srm_source_manager_class;


SRM_SourceManager::SRM_SourceManager() :
    nsources_(0),
    clock_(0),
    keep_sites_(0),
    site_drop_time_(0),
    generator_(NULL),
    appmgr_(NULL)
{
    memset((char*)hashtab_, 0, sizeof(hashtab_));
}


int
SRM_SourceManager::command(int argc, const char *const*argv)
{
    Tcl& tcl = Tcl::instance();

    if (argc == 4) {
	if (strcmp(argv[1], "local") == 0) {
	    srm_src sid;
	    // use base 16!
	    sid.ss_uid  = strtoul(argv[2], (char **)NULL, 16);
	    sid.ss_addr = strtoul(argv[3], (char **)NULL, 16);
	    SRM_Source *localsrc = create_local(sid);
	    if (localsrc==NULL || localsrc->name()==NULL) {
		Tcl_AddErrorInfo(Tcl::instance().interp(),
				 "could not create local source");
		return TCL_ERROR;
	    }
	    tcl.result(localsrc->name());
	    return (TCL_OK);
	}
	if (strcmp(argv[1], "create-source")==0) {
	    // this is just a stub; it doesn't do anything
	    // the OTCL code will redefine this to do whatever it needs
	    return (TCL_OK);
	}
    }
    if (argc == 3) {
	if (strcmp(argv[1], "site-drop-time") == 0) {
	    site_drop_time_ = atoi(argv[2]);
	    return (TCL_OK);
	}
	if (strcmp(argv[1], "delete") == 0) {
	    SRM_Source* s = (SRM_Source*)TclObject::lookup(argv[2]);
	    if (s != 0)
		remove(s);
	    return (TCL_OK);
	}

	if (strcmp(argv[1], "app-mgr") == 0) {
	    appmgr_ = (SRM_AppMgr*)TclObject::lookup(argv[2]);
	    return (TCL_OK);
	}

    }
    if (argc == 2) {
      if (strcmp(argv[1], "default-local-uid") == 0) {
	Tcl& tcl = Tcl::instance();
	char* wrk = tcl.buffer();
	sprintf(wrk, "%lx", (unsigned long) getuid());
	tcl.result(wrk);
	return TCL_OK;
      }

      if (strcmp(argv[1], "default-local-addr") == 0) {
	Tcl& tcl = Tcl::instance();
	char* wrk = tcl.buffer();
	sprintf(wrk, "%x", (unsigned) LookupLocalAddr());
	tcl.result(wrk);
	return TCL_OK;
      }
    }
    return (TclObject::command(argc, argv));
}


void
SRM_SourceManager::remove_from_hashtable(SRM_Source* s)
{
    /* delete the source from hash table */
    srm_src id = s->id();
    int h = SHASH(id.ss_uid);
    SRM_Source** p = &hashtab_[h];
    while (*p != s)
	p = &(*p)->hlink_;
    *p = (*p)->hlink_;
}


/*FIXME this is now more convoluted than it has to be...*/
SRM_Source *
SRM_SourceManager::create_local(const srm_src &sid)
{
    SRM_Source *localsrc = create_source(sid, 1); // create local source obj
    enter(localsrc);
    local_sources_.InsertAtHead(localsrc);
    return localsrc;
}


SRM_Source*
SRM_SourceManager::enter(SRM_Source* s)
{
    int h = SHASH(s->id().ss_uid);
    s->hlink_ = hashtab_[h];
    hashtab_[h] = s;

    ++nsources_;
    return (s);
}

SRM_Source*
SRM_SourceManager::consult(const srm_src &sid)
{
    int h = SHASH(sid.ss_uid);
    if (!hashtab_)
	return (0);
    for (SRM_Source* s = hashtab_[h]; s != 0; s = s->hlink_) {
	/*FIXME pulling these values into variable seems
	  to work around a DEC c++ bug */
	const srm_src id = s->id();
	if (sid==id) return (s);
    }
    return (0);
}

SRM_Source* SRM_SourceManager::create_source(const srm_src &sid, int islocal)
{
    /*FIXME should have helper method-invoker */
    Tcl& tcl = Tcl::instance();
    tcl.evalf("%s create-source %x %x", name(), sid.ss_uid, sid.ss_addr);
    SRM_Source *ssrc = (SRM_Source*)tcl.lookup(tcl.result());
    if (!ssrc) {
	MTrace(trcSRM, ("could not create srm source object"));
	return NULL;
    }

    SRM_PacketHandler *sp;
    if (appmgr_) {
      sp = appmgr_->new_source(sid, islocal);
      ssrc->handler(sp);
    }
    return ssrc;
}


/*SRM_Source* SRM_SourceManager::lookup(u_int32_t uid, u_int32_t addr)
{
    SRM_Source* s = consult(uid, addr);
    if (s == 0) {
	s = create_source(uid, addr);
	enter(s);
    }
    return (s);
}
SRM_Source* SRM_SourceManager::lookup_duplicate(u_int32_t uid, u_int32_t addr)
{
    return 0;
}*/


void
SRM_SourceManager::remove(SRM_Source* s)
{
    --nsources_;

    remove_from_hashtable(s);

    /* delete the source from list */
    /*SRM_Source** p = &sources_;
    while (*p != s)
	p = &(*p)->next_;
    *p = (*p)->next_;*/

    if (s == generator_)
	generator_ = 0;
    delete s;
}


SRM_Source*
SRM_SourceManager::demux(const srm_src &sid, u_int16_t /*seq*/)
{
    SRM_Source* s = consult(sid);
    if (s == 0) {
	s = create_source(sid, 0); // create non-local source object
	if (s!=0) enter(s);
    }
    return (s);
}
