/*
 * transducer-master.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 2000-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "transducer-master.h"
#include "tclcl.h"

#include <stdlib.h> // for atoi

static class MasterTransducerClass : public TclClass {
public:
	MasterTransducerClass() : TclClass("Transducer/Master") {}
	TclObject* create(int argc, const char*const* argv) {
		return(new MasterTransducer(argc, argv));
	}
} master_transducer_class;

MasterTransducer::MasterTransducer(int /* argc */,
                                   const char* const* /* argv */)
{
  numSlaves_ = 0;
  useSpoof_ = 0;
  spoofLevel_ = 0.0;
}

MasterTransducer::~MasterTransducer()
{
}

// by experimentation, this gets called every ~60 ms => ~16.6667 samples/sec
//    => 50 samples every 3 seconds
//
// by experimentation, it also appears that this "double" is always of the
//    form 60.00000, 32.0000, etc, i.e., converting it to an int loses no
//    precision
//
void MasterTransducer::set(double d)
{
  int x;

  if(useSpoof_)
  {
    d = spoofLevel_;
  }

  for(x = 0; x < numSlaves_; ++x)
  {
    if(slaveTransducers_[x] != NULL)
    {
      slaveTransducers_[x]->set(d);
    }
  }
}

int MasterTransducer::attachTransducer(const char* trans)
{
  if((numSlaves_ + 1) >= MAX_NUM_SLAVES)
  {
    return(-1);
  }
  slaveTransducers_[numSlaves_] = (Transducer*)TclObject::lookup(trans);
  numSlaves_++;
  return(1);
}

int MasterTransducer::command(int argc, const char* const* argv)
{
  int result;
  const char* cmd = argv[1];
  Tcl& tcl = Tcl::instance();

  if(argc == 2)
  {
    if(!strcmp(cmd, "enableSpoofing"))
    {
      useSpoof_ = 1;
      return(TCL_OK);
    }
    if(!strcmp(cmd, "disableSpoofing"))
    {
      useSpoof_ = 0;
      return(TCL_OK);
    }
  }
  if(argc == 3)
  {
    if(!strcmp(cmd, "setSpoofLevel"))
    {
      int val = atoi(argv[2]);
      // FIXME - should check for correctness here
      spoofLevel_ = (double)val;
      return(TCL_OK);
    }
    if(!strcmp(cmd, "attachTransducer"))
    {
      result = attachTransducer(argv[2]);
      if(result < 0)
      {
	// error
	tcl.result("MasterTransducer has reached limit, no more transducers can be attached");
	return(TCL_ERROR);
      }
      return(TCL_OK);
    }
  }

  // default to TclObject
  return(TclObject::command(argc, argv));
}

