/*
 * filter.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1991-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/audio/filter.h,v 1.5 2002/02/03 03:10:46 lim Exp $
 */

class Filter;
class FilterTap;

#ifndef vat_filter_h
#define vat_filter_h

#include "ss.h"
#include "audio.h"

/*
 * We do as much precomputation as possible for each filter tap.
 * The product field is a table of precomputed products of the filter
 * coefficient (which is not actually stored) with each of the possible
 * 256 ulaw encoded values.  The values are stored as linear 32 bit fixed
 * point numbers (16 bits of fraction).  The tapno field gives the
 * power of 1/z.
 */
struct FilterTap {
	double mod;
	int tapno;
	int product[256];
};

class Filter {
    public:
	Filter(Audio *);
	~Filter();
	void Create(double *, int, int);
	void Compute(SampleStream *, u_char *, int);
	void Train(int, int);
    private:
	int ntaps;
	Audio *audio;
	FilterTap *taps;
};

#endif
