/*
 * atobj-rreq.cc --
 *
 *      Atobj_request and Atobj_reply (for SRM reliability)
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MASH_ATOBJ_RREQ_CC
#define MASH_ATOBJ_RREQ_CC

#include "atobj-rreq.h"

#ifndef lint
static const char rcsid[] = "@(#) $Header: /usr/mash/src/repository/mash/mash-1/atobj/atobj-rreq.cc,v 1.9 2002/02/03 03:10:21 lim Exp $";
#endif

static const int cNumMaxRequest = 20; // cancel after asking for 10 times

/*virtual from SRM_Request*/
int Atobj_request::fill_ADU(Byte* pb, int len)
{
        Trace(VERYVERBOSE,("request::fill_adu"));
        // note that the request could be cancelled during updateRequest
        if (pRcvr_->updateRequest(this, anmId_)) {
#if 0 // just let the timer increase to whatever for now....
                // REVIEW what should be the right thing to do here?
                numtimes_++;
                if (numtimes_>cNumMaxRequest) {
                        // note: function will kill the object
                        pRcvr_->cancelRequest(this, anmId_, 1);
                        return 0;
                }
#endif
                backoff();
                return (pRcvr_->fillRequest(this, anmId_, pb,len));
        }
        return 0;
}

int Atobj_reply::fill_ADU(Byte* pb, int len)
{
        Trace(VERYVERBOSE,("repair::fill_adu"));
        // Note that replies might have to go out in multiple packets.
        // Assumption is receiver will cancel this reply after all the data
        // has been sent out.
        return pRcvr_->fillReply(this, anmId_, pb, len);
}

#endif /* #ifdef MASH_ATOBJ_RREQ_CC */
