# amx-header.tcl --
#
#       Header file containing all the global variables/constants for the amxd
#       implementation.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# amx library global variables
global g_amxCommands g_amxDevices g_amxChannels g_amxInvCommands

# for internal use only
global g_amxInvDevices g_amxInvChannels

set g_amxCommands(turnOn) 1
set g_amxCommands(turnOff) 2 
set g_amxCommands(getStatus) 3 
set g_amxCommands(sendString) 4
set g_amxCommands(sendCommand) 5
set g_amxCommands(push) 6
set g_amxCommands(release) 7
set g_amxCommands(deviceId) 8
set g_amxCommands(readAddress) 9
set g_amxCommands(pulse) 10
set g_amxCommands(responseMask) 11
set g_amxCommands(levelRequest) 15

set g_amxInvCommands(1) turnOn
set g_amxInvCommands(2) turnOff
set g_amxInvCommands(3) getStatus
set g_amxInvCommands(4) sendString
set g_amxInvCommands(5) sendCommand
set g_amxInvCommands(6) push
set g_amxInvCommands(7) release
set g_amxInvCommands(8) deviceId
set g_amxInvCommands(9) readAddress
set g_amxInvCommands(10) pulse
set g_amxInvCommands(11) responseMask
set g_amxInvCommands(15) levelRequest

# device numbers according to 4051299.axs
set g_amxDevices(computer) 1
set g_amxDevices(matrix) 2
set g_amxDevices(receiver) 3
set g_amxDevices(projector) 4
set g_amxDevices(lights) 5
set g_amxDevices(rackVCR) 6
set g_amxDevices(projectorLift) 7
set g_amxDevices(leftSlide) 8
set g_amxDevices(rightSlide) 9
# is the on-air sign also attached here?
set g_amxDevices(onAir) 10
set g_amxDevices(elmo) 10
set g_amxDevices(frontVCR) 11
set g_amxDevices(scanConverter) 12
# audio mixer
set g_amxDevices(mixer) 13
set g_amxDevices(audienceCamera) 14
set g_amxDevices(speakerCamera) 15
set g_amxDevices(remotePanel) 128
set g_amxDevices(touchPanel) 129

# device numbers according to 4051299.axs
set g_amxInvDevices(1) "computer"
set g_amxInvDevices(2) "matrix"
set g_amxInvDevices(3) "receiver"
set g_amxInvDevices(4) "projector"
set g_amxInvDevices(5) "lights"
set g_amxInvDevices(6) "rackVCR"
set g_amxInvDevices(7) "projectorLift"
set g_amxInvDevices(8) "leftSlide"
set g_amxInvDevices(9) "rightSlide"
set g_amxInvDevices(10) "elmo/onAir"
set g_amxInvDevices(11) "frontVCR"
set g_amxInvDevices(12) "scanConverter"
set g_amxInvDevices(13) "mixer"
set g_amxInvDevices(14) "audienceCamera"
set g_amxInvDevices(15) "speakerCamera"
set g_amxInvDevices(128) "remotePanel"
set g_amxInvDevices(129) "touchPanel"

#
# channels specific to each device
#

# Sony Projector
set g_amxChannels(projector,video1) 31
set g_amxChannels(projector,video2) 32
set g_amxChannels(projector,data1) 34
set g_amxChannels(projector,data2) 35

set g_amxInvChannels(projector,31) "video1"
set g_amxInvChannels(projector,32) "video2"
set g_amxInvChannels(projector,34) "data1"
set g_amxInvChannels(projector,35) "data2"

# lights
set g_amxChannels(lights,full) 9
set g_amxChannels(lights,overlay) 43
set g_amxChannels(lights,slide) 44
# this one doesn't work with AMX for some reason
#set g_amxChannels(lights,theater) 45
set g_amxChannels(lights,off) 55

set g_amxInvChannels(lights,9) "full"
set g_amxInvChannels(lights,43) "overlay"
set g_amxInvChannels(lights,44) "slide"
set g_amxInvChannels(lights,55) "off"

# onAir

set g_amxChannels(onAir,power) 8

# front VCR
set g_amxChannels(frontVCR,play) 1
set g_amxChannels(frontVCR,stop) 2
set g_amxChannels(frontVCR,pause) 3
set g_amxChannels(frontVCR,ffwd) 4
set g_amxChannels(frontVCR,rew) 5
set g_amxChannels(frontVCR,rec) 8
set g_amxChannels(frontVCR,power) 9

set g_amxInvChannels(frontVCR,1) "play"
set g_amxInvChannels(frontVCR,2) "stop"
set g_amxInvChannels(frontVCR,3) "pause"
set g_amxInvChannels(frontVCR,4) "ffwd"
set g_amxInvChannels(frontVCR,5) "rew"
set g_amxInvChannels(frontVCR,8) "rec"
set g_amxInvChannels(frontVCR,9) "power"

# rack VCR
set g_amxChannels(rackVCR,play) 1
set g_amxChannels(rackVCR,stop) 2
set g_amxChannels(rackVCR,pause) 3
set g_amxChannels(rackVCR,ffwd) 4
set g_amxChannels(rackVCR,rew) 5
set g_amxChannels(rackVCR,rec) 8
set g_amxChannels(rackVCR,power) 9

set g_amxInvChannels(rackVCR,1) "play"
set g_amxInvChannels(rackVCR,2) "stop"
set g_amxInvChannels(rackVCR,3) "pause"
set g_amxInvChannels(rackVCR,4) "ffwd"
set g_amxInvChannels(rackVCR,5) "rew"
set g_amxInvChannels(rackVCR,8) "rec"
set g_amxInvChannels(rackVCR,9) "power"

# speaker camera
set g_amxChannels(speakerCamera,up) 52
set g_amxChannels(speakerCamera,down) 53
set g_amxChannels(speakerCamera,left) 55
set g_amxChannels(speakerCamera,right) 54
set g_amxChannels(speakerCamera,in) 48
set g_amxChannels(speakerCamera,out) 47
set g_amxChannels(speakerCamera,center) 51
set g_amxChannels(speakerCamera,preset) 56

set g_amxInvChannels(speakerCamera,52) "up"
set g_amxInvChannels(speakerCamera,53) "down"
set g_amxInvChannels(speakerCamera,55) "left"
set g_amxInvChannels(speakerCamera,54) "right"
set g_amxInvChannels(speakerCamera,48) "in"
set g_amxInvChannels(speakerCamera,47) "out"
set g_amxInvChannels(speakerCamera,51) "center"
set g_amxInvChannels(speakerCamera,56) "preset"

# audience camera
set g_amxChannels(audienceCamera,up) 52
set g_amxChannels(audienceCamera,down) 53
set g_amxChannels(audienceCamera,left) 55
set g_amxChannels(audienceCamera,right) 54
set g_amxChannels(audienceCamera,in) 48
set g_amxChannels(audienceCamera,out) 47
set g_amxChannels(audienceCamera,center) 51
set g_amxChannels(audienceCamera,preset) 56

set g_amxInvChannels(audienceCamera,52) "up"
set g_amxInvChannels(audienceCamera,53) "down"
set g_amxInvChannels(audienceCamera,55) "left"
set g_amxInvChannels(audienceCamera,54) "right"
set g_amxInvChannels(audienceCamera,48) "in"
set g_amxInvChannels(audienceCamera,47) "out"
set g_amxInvChannels(audienceCamera,51) "center"
set g_amxInvChannels(audienceCamera,56) "preset"

# touch panel
set g_amxChannels(touchPanel,pcToProj) 136
set g_amxChannels(touchPanel,vcrToProj) 137
set g_amxChannels(touchPanel,elmoToProj) 138
set g_amxChannels(touchPanel,laptopToProj) 139
set g_amxChannels(touchPanel,sgiToProj) 140

set g_amxInvChannels(touchPanel,136) pcToProj
set g_amxInvChannels(touchPanel,137) vcrToProj
set g_amxInvChannels(touchPanel,138) elmoToProj
set g_amxInvChannels(touchPanel,139) laptopToProj
set g_amxInvChannels(touchPanel,140) sgiToProj

# remote panel
set g_amxChannels(remotePanel,pcToProj) 136
set g_amxChannels(remotePanel,vcrToProj) 137
set g_amxChannels(remotePanel,elmoToProj) 138
set g_amxChannels(remotePanel,laptopToProj) 139
set g_amxChannels(remotePanel,sgiToProj) 140

set g_amxInvChannels(remotePanel,136) pcToProj
set g_amxInvChannels(remotePanel,137) vcrToProj
set g_amxInvChannels(remotePanel,138) elmoToProj
set g_amxInvChannels(remotePanel,139) laptopToProj
set g_amxInvChannels(remotePanel,140) sgiToProj
