<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

session_start();
if (is_opendb_valid_session())
{					 
	$show_error=TRUE;	
	if( (strlen($HTTP_VARS['title'])>0 || strlen($HTTP_VARS['imdb_id'])>0) && $HTTP_VARS['op'] == "search")
	{
		$readfile = NULL;
		
   		if(strlen($HTTP_VARS['imdb_id'])==0)
		{
			echo "<p>".replace_lang_var("search", $HTTP_VARS['title'], $LANG_VARS['you_searched_for'])."</p>";
			$id = get_imdb_title_id($HTTP_VARS['title'], $readfile);
		}
		else
		{
			$id = $HTTP_VARS['imdb_id'];
		}
		
   		if($id !== -1) // page was actually read!
        {
       		// Title not found, need to generate listing.
			if ($id === FALSE)
            {
				$titles_list = get_imdb_common_titles_list($HTTP_VARS['title'], $HTTP_VARS, $readfile);
				if($titles_list)
				{
					echo $titles_list;
            	    $show_error=FALSE;
				}
			}                
			else
           	{
       	    	$attributes = parse_imdb_data($id, $readfile);
   	        	if($attributes)
        		{
					// Add imdb_id to $entry array.
					$attributes['imdb_id'] = $id;
					
					echo get_site_blurb_chooser(
						"imdb", 
						$attributes,
						'plot', // plot or review
						$HTTP_VARS, 
						array('id','imdb_id','title'));
       				$show_error=FALSE;
				}   
       	    }    
   	    }
    }
   	else if (strlen($HTTP_VARS['title'])>0 && $HTTP_VARS['op'] == "listing")
    {
		echo "<p>".replace_lang_var("search", $HTTP_VARS['title'], $LANG_VARS['you_searched_for'])."</p>";
		echo get_imdb_all_titles_list($HTTP_VARS['title'], $HTTP_VARS);
   	   	$show_error=FALSE;
    }
   	else if (strlen($HTTP_VARS['id'])>0 && $HTTP_VARS['op'] == "choose")
    {
		$attributes = parse_imdb_data($HTTP_VARS['id']);
        if($attributes)
		{
			// Add imdb_id to $entry array.
			$attributes['imdb_id'] = $HTTP_VARS['id'];
			
			echo get_site_blurb_chooser(
						"imdb", 
						$attributes,
						'plot', // plot or review
						$HTTP_VARS, 
						array('id','imdb_id','title'));
						
        	$show_error=FALSE;
		}            
   	}
	
	if($show_error)
	{
		echo ("<H3>".$LANG_VARS['no_matches_found']."</H3>");
	}
}
?>
