<?php
/*	Time-stamp: <2002-09-11 11:43:33 ard>
 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

This script produces a table, one row per HTTP cache file, sorted by
descending expiry date (freshest file at the top, oldest at the bottom).

TODO: only print "delete all stale entries" if there are stale entries.
Tricky (ugly) to do without putting the link after the list, which would
force users to scroll to the bottom to find it.
*/

include_once("./functions/datetime.php");

function delete_older_than($when)
{
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;
	
	if($dir = @opendir("cache"))
	{
		$deleted_files = 0;
		$failed_files = NULL;
		while (($file = readdir($dir)) !== false)
		{
			// Ignore the special '.' unix directories.
			if (strcmp('.', $file)!==0 && strcmp('..', $file)!==0)
			{
				$fstat = @stat('cache/' . $file);	// Assume good.
				if ($fstat[9] <= $when)
				{
					if(@unlink("cache/$file"))
					{
						$deleted_files++;
					}
					else
					{
						$failed_files[] = $file;
					}
				}
			}
		}
		@closedir($dir);
		
		if($deleted_files>0)
		{
			opendb_log("HTTP_CACHE: Deleted $deleted_files cache files. (update_who=".$HTTP_SESSION_VARS['user_id'].")");
		}
		
		if(is_not_empty_array($failed_files))
		{
			echo("<p class=\"error\">Error deleting:<ul class=\"smerror\">");
			while(list(,$value) = each($failed_files))
			{
				echo("<li>$value</li>");
			}
			echo("</ul></p><br>");
		}
	} // Ignore error; very unlikely given this fn must be called after the
	  // dir has already been read successfully.

}

session_start();
if (is_opendb_valid_session())
{ 
	$now = time();
	if (is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
	{
		$lifetime = ($CONFIG_VARS['http_cache.lifetime']) ? $CONFIG_VARS['http_cache.lifetime'] : 86400 * 7;
		if ($HTTP_VARS['op'] == 'flush')
		{
			// clean out the whole cache.  Everything older than a few minutes,
			// anyway.  We don't want to delete a cache entry that is being
			// written to, or is about to be read back, and there's no other way
			// to see if the file is being held open (link count is 1).
			delete_older_than($now - 600);
		}
		else if ($HTTP_VARS['op'] == 'flushstale')
		{
			// clean out all stale entries.  Give a 10s window in case some
			// other page is about to open it.
			delete_older_than($now - $lifetime - 10);
		}
		else if ($HTTP_VARS['op'] == 'unlink' && is_numeric($HTTP_VARS['olderthan']))
		{
			delete_older_than($HTTP_VARS['olderthan']);
		}
		else if ($HTTP_VARS['op'] == 'unlink' && $HTTP_VARS['file'])
		{
			// Attempted to specify a file, with directory information, this is not allowed!
			if(!strstr($HTTP_VARS['file'], '/') && @unlink("cache/".$HTTP_VARS['file']))
			{
				opendb_log("CACHE: Deleted ".$HTTP_VARS['file']." (update_who=".$HTTP_SESSION_VARS['user_id'].")");
			}
			else
			{
				opendb_log("CACHE: Error deleting ".$HTTP_VARS['file']." (update_who=".$HTTP_SESSION_VARS['user_id'].")");
				echo("<p class=\"error\">Error deleting <u>".$HTTP_VARS['file']."</u></p>\n");
			}
		}
    
		if ($dir = @opendir("cache"))
		{
			$list = array();
			while (($file = readdir($dir)) !== false)
			{
				if (! (strcmp('.', $file) && strcmp('..', $file))) continue;
				$fstat = stat('cache/' . $file);	// Assume good.
				$list[$file] = $fstat[9];
			}  
			closedir($dir);
			
			echo("<table width=100% cellspacing=1 border=0>");
			
			// Do not display links if no files to operate on.
			if(is_not_empty_array($list))
			{
				echo("<tr><td align=\"center\" colspan=3>"
					."<p>[<a href=\"admin.php?type=$ADMIN_TYPE&op=flushstale\">Delete all stale cache entries</a>]&nbsp;"
					."[<a href=\"admin.php?type=$ADMIN_TYPE&op=flush\">Delete all cache entries</a>]</p>"
					."</td></tr>");
				echo("<tr><td align=\"center\" colspan=3>&nbsp;</td></tr>");
			}

			echo("<tr></tr>".
				"<tr><td class=\"navbar\" width=60%>URL</td><td class=\"navbar\" width=20%>Expires</td><td class=\"navbar\" width=20%>Action</td></tr>");
			if(is_not_empty_array($list))
			{
				function cmp($a,$b)
				{
					global $list;
					if ($list[$a] == $list[$b]) return 0;
					return ($list[$a] > $list[$b]) ? -1 : 1;
				}
				uksort($list, 'cmp');
			
				$goodtime = $now - $lifetime;
				$toggle = TRUE;
				foreach ($list as $file => $fstat)
				{
					if($toggle)
						$color="top";
					else
		 				$color="top2";
					$toggle = !$toggle;
					
					echo("<tr>");
				
					echo("<td class=\"$color\">"
							.wordwrap(urldecode(urldecode($file)),80,"\n",1)
							."</td>");
							
					echo("<td align=\"center\" class=\"$color\">"
							.get_localised_timestamp($CONFIG_VARS['http_cache.datetime_mask'], $fstat + $lifetime)
							.($fstat < $goodtime?"&nbsp;(Stale)":"")
						 	."</td>");
						 
					echo("<td align=\"center\" class=\"$color\">"
						."[<a href=\"admin.php?type=$ADMIN_TYPE&op=unlink&file=".urlencode($file)."\">Delete</a> / "
						."<a href=\"admin.php?type=$ADMIN_TYPE&op=unlink&olderthan=$fstat\">Delete&nbsp;Older</a>]"
						."</td>");
			
					echo("</tr>");	
				}
			}
			else
			{
				echo("\n<tr><td colspan=3 align=center><div class=\"error\"><b>- No Files Found -</b></div></td></tr>");
			}
			echo("</table>");
			
			echo(format_help_block($http_cache_help));
		}
		else // No cache defined
		{
			echo _theme_error('No Cache Directory found');
		}
	}
	else
	{
		echo _theme_error($LANG_VARS['not_authorized_to_page']);
	}	
	echo _theme_footer();
}//(is_opendb_valid_session())
?>
