#!/usr/bin/perl
# This program takes an XML document and splits it into separate lines so that
# I can look at them and see how they work easier.

my($file) = $ARGV[0];
&Usage unless($file);
&Usage unless(-f $file);

open(FILE, $file);
while($line = <FILE>) {
    $line =~ s/\/>/\/>\n/g;
    $line =~ s/(<[^\/])/\n$1/g;
    print $line;
}
close($file);

sub Usage {
    print "Usage:\n\n";
    print "  lines.pl FILENAME.xml\n\n";
    exit;
}
