/*
   File: ds.h
   Author: mhandley
   Date: Mon Jul  4 16:15:01 BST 1994
   Purpose: Data Structures used for holding text
*/
#include <sys/types.h>
#include <time.h>
#include <stdio.h>
#include "general_types.h"

#define MAX_LINE_LEN 160
#define MAX_BLOCK_LEN 200
#define MAX_SEG_LEN 80
#define MAX_USER_NAME 9
#define STYLE_LEN 8
#define ID_LEN 20
#define TRUE    1
#define FALSE   0

#define UNKNOWN_LINE 65533
#define LOCAL_LINE 65534
#define LINE_DELETED 65535

#define INFO_RTX 1
#define DATA_RTX 2
#define NORMAL_RTX 3 

/*Values for status fields: (in the block struct)*/
#define NORMAL 1
#define LOCKED 2
#define DELETED 3
/* block status, stored in xpos */

#define UNDELETED 107					
											/* added by jim - so that we*/
											/* can announce undeletions and hopefully*/
											/* stop more than one person undeleting the*/
											/* same block*/
		/* Why store undelete in xpos? I have done this so that I can still transmit the*/
		/* blocks as deleted, and store them as deleted (so they don't get redisplayed, etc).*/
		/* I need the extra undeleted info so that I can attempt to remove them from the */
		/* recent-deleted-blocks list at each other host. */

typedef struct user_data_s
{
  char username[MAX_USER_NAME];
  char hostaddr[MAXHOSTNAMELEN];
} user_data;

typedef struct 
{
  int start;
  int stop;
  char blockid[ID_LEN];
} taginfo;

typedef struct
{
  u_int16 keyindex;
  u_int8 colindex;
  u_int8 fontindex;
} typeface;

typedef struct line_s
{
  u_int8 type;
  char checksum[20];
  char lineid[ID_LEN];
  char nextid[ID_LEN]; /*set when we need to sort out some mess*/
  char previd[ID_LEN]; /*otherwise set to "NULL"*/  
  struct timeval last_mod;
  struct user_data_s modifier;
  struct line_s *next_line;
  struct line_s *prev_line;
  struct block_s *block;
  u_int8 no_of_chars;
  u_int8 status;
  u_int16 missing_lines;
  u_int16 linenum; /*set to LINE_DELETED when the line has been*/
  char line_data[MAX_LINE_LEN];
} line;

typedef struct block_s
{
  u_int8 type;
  char checksum[20];
  char blockid[ID_LEN];
  struct timeval last_mod;
  u_int16 no_of_lines;
  u_int16 ypos;
  u_int8 xpos;
  u_int8 status;
  line *first_line;
  struct block_s *next_block;
  struct block_s *prev_block;
  struct user_data_s originator;
  struct user_data_s modifier;
  typeface face;
  int rtx_status;			/* Stores the current status of the block's retransmission
								since we last calculated our checksum */
  int new_data;
} block;

typedef struct page_s
{
  char checksum[20];
  struct timeval last_mod;
  u_int16 no_of_blocks;
  struct page_s *next_page;
  struct page_s *prev_page;
  block *first_block;
  block *last_block;
} page;

typedef struct
{
  int checksum;
  struct timeval last_mod;
  u_int16 no_of_pages;
  page *first_page;
  page *last_page;
} document;

typedef struct
{
  int x;
  int y;
  u_int8 col;
  char id[ID_LEN];
  char style[STYLE_LEN];
  char username[MAX_USER_NAME];
} pointer;



typedef struct
{
  char *data;
  unsigned int no_of_lines;
} page_text;


