/*
 Network Security MONintor
 (c)Copyright 1998-99 Tibor Koleszar
 The original functions are made by Dr. Michael Meskes (c) 1996-1997 <meskes@online-club.de>,
 Changes by Tibor Koleszar (c) 1998-99 <t.koleszar@somogy.hu>
*/

#include "config.h"
#include "ping_test.h"

static int in_cksum(unsigned short *addr, int len)
{
    int nleft = len, sum = 0;
    unsigned short *w = addr, answer = 0;

    while (nleft > 1) {
	sum += *w++;
	nleft -= 2;
    }				
    if (nleft == 1) {
	*(unsigned char *) (&answer) = *(unsigned char *) w;
	sum += answer;
    }

    sum = (sum >> 16) + (sum & 0xffff);	
    sum += (sum >> 16);		
    answer = ~sum;		
    return (answer);
}

int test_ping(unsigned int target, int time)
{
    int i, sock_fp = -1;
    unsigned char *packet;
    struct sockaddr to;
    struct protoent *proto;
    int hold = 48 * 1024;
    unsigned char outpack[MAXPACKET];

    /* set up pinging if in network mode */
    if (target != -1) {
	/* setup the socket */
	memset(&to, 0, sizeof(struct sockaddr));

	((struct sockaddr_in *) &to)->sin_family = AF_INET;
	((struct sockaddr_in *) &to)->sin_addr.s_addr = target;

	if (!(packet = (unsigned char *) malloc((unsigned int) (DATALEN + MAXIPLEN + MAXICMPLEN)))) {
	    fprintf(stderr, "NSMON FATAL: out of memory\n");
	    exit(1);
	}
	if (!(proto = getprotobyname("icmp"))) {
	    fprintf(stderr, "NSMON FATAL: unknown protocol icmp.\n");
	    exit(1);
	}
	if ((sock_fp = socket(AF_INET, SOCK_RAW, proto->p_proto)) < 0) {
	    perror("NSMON");
	    exit(1);
	}
	(void) setsockopt(sock_fp, SOL_SOCKET, SO_RCVBUF, (char *) &hold,
			  sizeof(hold));
    }
    
    if (target == -1) {
        close(sock_fp);
	return 0;
    }

    /* try at most five times */
    for (i = 0; i < 5; i++) {

	struct sockaddr_in from;
	int fromlen, fdmask, j;
	struct timeval timeout;
	struct icmphdr *icp = (struct icmphdr *) outpack;

	/* setup a ping message */
	icp->type = ICMP_ECHO;
	icp->code = icp->checksum = icp->un.echo.sequence = 0;
	icp->un.echo.id = getpid();	/* ID */

	/* compute ICMP checksum here */
	icp->checksum = in_cksum((unsigned short *) icp, DATALEN + 8);

	/* and send it out */
	j = sendto(sock_fp, (char *) outpack, DATALEN + 8, 0, &to,
		   sizeof(struct sockaddr));

	if (j < 0) {
	    int err = errno;

	    /* if our kernel tells us the network is unreachable we are done */
	    if (err == ENETUNREACH) {  	/* USE_SYSLOG NETWORK IS UNREACHABLE */
                close(sock_fp);
		return 1;
	    } else {  /* OTHERWRROR */
                close(sock_fp);
                return 1;
	    }
	} else {
	    /* set the timeout value */
	    timeout.tv_sec = time;
	    timeout.tv_usec = 0;

	    /* wait for reply */
	    fdmask = 1 << sock_fp;
	    if (select(sock_fp + 1, (fd_set *) & fdmask, (fd_set *) NULL,
		       (fd_set *) NULL, &timeout) >= 1) {

		/* read reply */
		fromlen = sizeof(from);
		if (recvfrom(sock_fp, (char *) packet, DATALEN + MAXIPLEN + MAXICMPLEN, 0,
			     (struct sockaddr *) &from, &fromlen) < 0) {
		    int err = errno;

		    if (err != EINTR)  /* USE_SYSLOG  Other receive error*/
		    {
                     close(sock_fp);
		     return 1;
		    }
		    continue;
		}
		/* check if packet is our ECHO */
		icp = (struct icmphdr *) (packet + (((struct ip *) packet)->ip_hl << 2));

		if (icp->type == ICMP_ECHOREPLY) {
		    if (icp->un.echo.id == getpid()) /* got one back, that'll do it for now */
		    {
                      close(sock_fp);
                      return 0;
                    }
		}
	    }
	}
    }
    close(sock_fp);
    return 1; /* Network is unreachable */
}
