 /*
 Network Security MONintor 
 (c)Copyright 1998-99 Tibor Koleszar
*/

#include "run_check.h"
#include "ping_test.h"
#include "config.h"
#include "port_test.h"
#include <string.h>


/*****************************************************************************/
/*    Handle the SIGTERM signal                                              */
/*                                                                           */
/*****************************************************************************/
void theend(int sig) 
{
 if (sig == SIGTERM) 
 {
  logit("Stopped. Got SIGINT/SIGTERM signal.");
  fprintf(stderr, "nsmon: Stopped. Got SIGTERM signal.");  
  exit(0);
 }
}

/*****************************************************************************/
/*   B a s e  c o d e                                                        */
/*                                                                           */
/*****************************************************************************/
int main(int argc, char *argv[]) 
{
 struct timespec tspec;
 struct hostent *hostn;
 struct sockaddr_in serv_addr;
 struct in_addr *addr;
 int i;
 char dummy[1024], dummy2[512];


 if (argc >= 2) {

  if (!strcmp(argv[1], "--version") || !strcmp(argv[1], "-v")) {
   printf("NsMon version %s.\n", VERSION);
   exit(0);
  }
  if (!strcmp(argv[1], "--help") || !strcmp(argv[1], "-h")) {
   printf("NsMon version %s.\nUsage: %s <config file>\n", VERSION, argv[0]);
   exit(0);
  }
 }

 if (argc < 2) { read_config(DEFAULT_CONFIG); } 
  else { read_config(argv[1]); }

 for (i=0; i<hostnum; i++) 
 {
  memset( (char *)&serv_addr, 0, sizeof( serv_addr ) );
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = inet_addr( hosts[i].name );
  if (serv_addr.sin_addr.s_addr == -1) 
  {
   hostn = gethostbyname(hosts[i].name);
   if (hostn != NULL) 
   { 
    addr = (struct in_addr*)hostn->h_addr_list[0];
    serv_addr.sin_addr.s_addr = addr->s_addr; 
   } else 
   { 
    fprintf(stderr, "NSMON FATAL: can't find inet_addr for %s host.\n", hosts[i].name); 
    _exit(0); 
   }
  }
  hosts[i].inetaddress = serv_addr.sin_addr.s_addr;
 }

 sprintf(dummy, "NsMon %s started.", VERSION); logit(dummy);
 sprintf(dummy, "Config has read, found %d checkhost(s)", hostnum); logit(dummy);

 for (j=0; j < hostnum; j++) 
 {
  sprintf(dummy, "INIT	%s (inet_addr = %u)", hosts[j].name, hosts[j].inetaddress);
  if (hosts[j].portchecknum > 0)
  {
   strcat(dummy, " port(s): ");
   i=0;
   while (i<hosts[j].portchecknum) 
   {
    if (i+1 != hosts[j].portchecknum) { sprintf(dummy2, "%s(%d), ", hosts[j].portname[i], hosts[j].portnum[i]); }
    else { sprintf(dummy2, "%s(%d)", hosts[j].portname[i], hosts[j].portnum[i]); }
    strcat(dummy, dummy2);
    i++;
   }
  }
  logit(dummy);                                           
 }                     
 
 counter = 0;

 signal(SIGTERM, theend);
 signal(SIGALRM, run_check);
 alarm(60);

 /*******************************************/
 /*         M A I N    L O O P              */
 /*******************************************/

 for ( ;; ) 
 {
   tspec.tv_sec = 60;
   tspec.tv_nsec = 0;
   nanosleep((struct timespec*)&tspec, NULL);
 } 
 
 return 0;
}	