/*

Copyright (C) 2000, 2001, 2002 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_protocol_instance_h
#define __nd_protocol_instance_h

#include <gtk/gtk.h>

#include <netdude/nd.h>
#include <netdude/nd_protocol.h>

struct nd_proto_inst
{
  ND_Protocol  *proto;
  guint         nesting;
};

struct nd_proto_data
{
  ND_ProtoInst  inst;

  guchar       *data;
  guchar       *data_end;

};

struct nd_proto_info
{
  ND_ProtoInst  inst;

  GtkWidget    *proto_tab;
  GtkWidget    *proto_gui;
  GtkWidget    *proto_label;

  GHashTable   *registry;
};


void              nd_proto_inst_init(ND_ProtoInst *inst, ND_Protocol *protocol, guint nesting);
const char       *nd_proto_inst_to_string(const ND_Protocol *proto, guint nesting);

ND_ProtoData     *nd_proto_data_new(ND_Protocol *protocol, guint nesting, guchar *data, guchar *data_end);
void              nd_proto_data_free(ND_ProtoData *pd);

ND_ProtoInfo     *nd_proto_info_new(ND_Protocol *proto, guint nesting);
void              nd_proto_info_free(ND_ProtoInfo *pinf);
void              nd_proto_info_set_data(ND_ProtoInfo *pinf, const char *key, void *data);
void             *nd_proto_info_get_data(const ND_ProtoInfo *pinf, const char *key);
void             *nd_proto_info_remove_data(ND_ProtoInfo *pinf, const char *key);

/**
 * nd_proto_info_field_set_state - sets the state of a protocol header field.
 * @trace: trace in which to update GUI.
 * @field: field to update.
 * @state: new state.
 *
 * This function updates the state of a header field button,
 * including GUI updates.
 */
void           nd_proto_info_field_set_state(ND_ProtoInfo *pinf,
					     ND_ProtoField *field,
					     ND_ProtoFieldState state);

#endif
