/*

Copyright (C) 2000, 2001, 2002 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <netdude/nd.h>
#include <netdude/nd_debug.h>
#include <netdude/nd_gui.h>
#include <netdude/nd_packet_iterator.h>

void
nd_pit_init(ND_PacketIterator *pit, ND_Trace *trace, gboolean selected)
{
  if (!pit || !trace)
    return;

  memset(pit, 0, sizeof(ND_PacketIterator));
  
  pit->trace  = trace;
  pit->selected = (trace->apply_to_all ? FALSE : selected);
  pit->current_index = 0;

  if (pit->selected)
    {
      pit->current = nd_trace_sel_get(trace, FALSE);
      nd_gui_pbar_reset(nd_trace_sel_size(trace));
    }
  else
    {
      pit->current = trace->pl;
      nd_gui_pbar_reset(nd_trace_size(trace));
    }
}


ND_Packet *
nd_pit_get(ND_PacketIterator *pit)
{
  if (!pit)
    return NULL;

  if (pit->current)    
    return pit->current;

  return NULL;
}


ND_Packet *           
nd_pit_next(ND_PacketIterator *pit)
{
  if (!pit)
    return FALSE;

  nd_gui_pbar_inc();

  if (pit->selected)
    {
      pit->current = nd_trace_sel_next(pit->trace, pit->current);
    }
  else
    {
      pit->current = pit->current->next;
      pit->current_index++;
    }

  return pit->current;
}


int                
nd_pit_get_index(ND_PacketIterator *pit)
{
  if (!pit || pit->selected)
    return -1;

  return pit->current_index;
}
