(* $Id: http_client_aux.mli 126 2004-05-25 20:56:41Z gerd $
 * ----------------------------------------------------------------------
 * Auxiliary functions for which two implementations exist, one which is
 * multi-threading safe, one which is not.
 *)

(* The following functions match strings with a fixed pattern and return
 * the interesting substrings. 
 * Always Not_found is raised if matching fails.
 *)

val match_query : string -> (string * int * string)
val match_status : string -> (string * int * string)
val match_header_line : string -> (string * string)
val match_hex : string -> string
val match_ip : string -> string
val match_http : string -> (string option *
			    string option *
			    string *
			    int *
			    string)

(* Splits a string into pieces separated by a pattern: *)

val split_words_by_commas : string -> string list

(* Mutexes: *)

module Mtx :
    sig
      type t
      val create: unit -> t
      val lock: t -> unit
      val try_lock: t -> bool
      val unlock: t -> unit
    end


