#TRUSTED 50b5204231bf77795830517a37fa0beb322a54758ee94ef1e8e6837f2d08dba9c8511eeb556ed18bd05f3e10b3a22c2d01a570af7f22086c60ef078d77bbb696225ff008e3585b899a5a3c9ade4de2bca6fc328e34b088139d20355e90f0580df1dbf8ba50831e229943ba3c4f7206807ffe842ba5399e2f3cf899c544e06f17b9e003c01dc074c6b240b551997a32e6babeb1b66ff1dbc01510edad9f5e21bf1c5ab842135a89410ee5d1e9796fef3a26a92047802c45e747aaeb1b1df9778e6987d0c18496a2744b55ff81dbe0c2fa850ccd59cc7218b54549f002fbfe4af7bfc87be8db604e0d14517c29ff774ed5b6dd67d8dd4ef0031eb303122baf07c19f28491d3b1a8ddbe9eafd4deb334e819c07ecfb5ec8c7c5362ee97696da005702efe530b0e53d5f5b5f627bc96fb85c01d6fdeb85bf636266dd847dae9a3a594b7e2bb848c1540a76ab394598b312b97000211d35adc012900d1c6d0e8cf353067521e5195972d7cd349405856dcbc670f67fc7d0700f7ea0eb8e515cb72f82ed29fbbce9063281676105c5cfb1fee1e555237aebae3e0774c9045405e6188cfc1f6505e02a937d74043f0afe373c2fb9259d03dc6118dd3f0014e3ffb1e5762eed4b84ce1ba8c1906e7d37cabadc5c6612c7a34530cf19708773cba843f504ce7201f807fbddfda23871cf36131877949d05af5c9e269385897a994a7c163a
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15878);
 script_version ("1.1");
 name["english"] = "Hydra: MS SQL";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find MS SQL passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force MS SQL authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/mssql", 1433);
 script_dependencies("hydra_options.nasl", "find_service.nes", "mssqlserver_detect.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/mssql");
if (! port) port = 1433;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "mssql";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/mssql/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following MS SQL accounts:\n' + report);
