.\" $Id: nasd.man,v 1.4 2004/02/14 23:38:32 jon Exp $
.TH NASD 1 "" ""
.SH NAME
nasd \- Network Audio System server
.SH SYNOPSIS
.B nasd
[:listen port offset] [\-option ...]
.SH DESCRIPTION
.I nasd
is the generic name for the Network Audio System server.  It is frequently a link
or a copy of the appropriate server binary for driving the most frequently
used server on a given machine.
.SH "STARTING THE SERVER"
The server is usually started from /etc/rc or a user's startup script.
.PP
When the Network Audio System server starts up, it takes over
/dev/audio.  Note, that if ReleaseDevice is set to TRUE [default] in
the nasd.conf file, nasd will relinquish control of the audio device
whenever it has finished playing a sound.  This means you can use
other non-NAS applications when nasd is running, as long as nasd isn't
currently playing a song.  If ReleaseDevice is set to FALSE in the
nasd.conf file, applications that attempt to access /dev/audio themselves will
fail while nasd is running.
.SH "NETWORK CONNECTIONS"
The Network Audio System server supports connections made using the following reliable
byte-streams:
.TP 4
.I TCP\/IP
.br
The server listens on port 8000+\fIn\fP, where \fIn\fP is the listen 
port offset.
.TP 4
.I "Unix Domain"
The X server uses \fI/tmp/.sockets/audio\fBn\fR as the filename for 
the socket, where \fIn\fP is the display number.
.SH OPTIONS
All of the Network Audio System servers accept the following generic
command line options.  Options specific to a particular server may
also be available, and are not listed here.  Try 'nasd -?' for a list
of those options, if available.
.TP 8
.B \-aa
Allows any client to connect.  By default, access is allowed
only to authenticated clients.
.TP 8
.B \-local
Allows only clients on the local host to connect.  By default, access
is allowed to local and remote hosts.
.TP 8
.B \-v
Enable verbose messages.  This option overrides the
nasd.conf file setting.
.TP 8
.B \-b
Fork a child to run in the background and exit (daemon mode).
.TP 8
.B \-d \fIn\fP
Enable debugging output at level \fIn\fP, where \fIn\fP is a positive
integer.  The higher the level, the more output you will get.  A value
of 0 [default] disables debugging output.  This option overrides the
nasd.conf file setting.  When debugging is enabled, stderr is not
closed by the nasd process, and all debugging messages are written
there.
.TP 8
.B \-pn
.TP 8
.B \-nopn [default]
Enables or disables Partial Networking.  Enabling Partial Networking
allows the server to start, even if the server cannot establish all of
its well-known sockets (connection points for clients), but
establishes at least one.
.TP 8
.B \-config \fIfile\fP
Use the config file \fIfile\fP, instead of the default (/etc/nasd/nasd.conf).
.SH SIGNALS
The Network Audio System server attaches special meaning to the following signals:
.TP 8
.I SIGHUP
This signal causes the server to close all existing connections, free all
resources, and restore all defaults.
.TP 8
.I SIGTERM
This signal causes the server to exit cleanly.
.TP 8
.I SIGUSR1
This signal is used quite differently from either of the above.  When the
server starts, it checks to see if it has inherited SIGUSR1 as SIG_IGN
instead of the usual SIG_DFL.  In this case, the server sends a SIGUSR1 to
its parent process after it has set up the various connection schemes.
.SH DIAGNOSTICS
Too numerous to list them all.
.SH FILES
.TP 30
/tmp/.sockets/audio*
Unix domain socket
.TP 30
/usr/adm/audio*msgs
.TP 30
/dev/audio
Audio device
.SH "SEE ALSO"
nas(1), auinfo(1), auplay(1), auctl(1), nasd.conf(1)
.SH BUGS
.PP
If
.I au
dies before its clients, new clients won't be able to connect until all
existing connections have their TCP TIME_WAIT timers expire.
.PP
The current access control support is weak at best.
.PP
.SH COPYRIGHT
Copyright 1993, Network Computing Devices, Inc.
.br
.SH AUTHORS
The Network Audio System server was originally written by Greg Renda
and Dave Lemke, with large amounts of code borrowed from the sample X
server.
.sp
The sample X server was originally written by Susan Angebranndt, Raymond
Drewry, Philip Karlton, and Todd Newman, from Digital Equipment
Corporation, with support from a large cast.  It has since been
extensively rewritten by Keith Packard and Bob Scheifler, from MIT.
