//
//  MAccessoryScrollView.m
//  MySQLGUICommon
//
//  Created by Alfredo Kojima on 9/3/04.
//  Copyright 2004 MySQL AB. All rights reserved.
//

#import "MAccessoryScrollView.h"


@implementation MAccessoryScrollView


- (void)dealloc
{
  [_accessoryViews release];
  [super dealloc];
}


- (void)addAccessoryView:(NSView*)view
{
  if (!_accessoryViews)
    _accessoryViews= [[NSMutableArray alloc] init];
  
  [_accessoryViews addObject:view];
  [self tile];
}


- (void)tile
{
  int i;
  NSRect rect, prect;
  NSScroller *hscroller= [self horizontalScroller];
  float x;

  // 1st do the default arrangement 
  [super tile];
  
  prect= [self frame];
  rect= [hscroller frame];
  
  x= rect.origin.x;
  // now arrange our accessory views
  for (i= 0; i < [_accessoryViews count]; i++)
  {
    NSView *view= [_accessoryViews objectAtIndex:i];
    float w= [view frame].size.width;
    [view setFrame:NSMakeRect(x, rect.origin.y, w, rect.size.height)];
    [view setNeedsDisplay:YES];
    x+= w;
  }
  rect.origin.x+= x;
  rect.size.width-= x;
  [hscroller setFrame:rect];
  [hscroller setNeedsDisplay];
}


@end
