/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/**
 * @file myx_gc_datatypes.h 
 * @brief Some commonly used data types.
 * 
 */

#ifndef __GC_GL_DATATYPES_H__
#define __GC_GL_DATATYPES_H__

#include <string>
#include <assert.h>
#include <hash_map>

#include "glib.h"

// Assertion macro with custom message.
#ifdef _WINDOWS
  #define ASSERT(exp, message) (void)( (exp) || (_assert(message, __FILE__, __LINE__), 0))
#else
  // TODO: Create ASSERT macro if needed for non-Windows platforms.
  #define ASSERT
#endif // #fidef _WINDOWS

// There is no ANSI rounding function for float numbers, so define our own.
#define ROUND(X) (int)((X) < 0 ? (X) - 0.5 : (X) + 0.5)

using namespace std;

//----------------------------------------------------------------------------------------------------------------------

// A floating point rectangle used for area sizes (e.g. of the canvas).
typedef struct tagBounds
{
  double Left, Top, Right, Bottom;
} TBounds;

typedef struct tagViewport
{
  int Left, Top, Width, Height;
} TGCViewport;

typedef enum tagGCError
{
  GC_NO_ERROR = 0, 
  GC_CANT_OPEN_FILE, 
  GC_XML_PARSE_ERROR,
  GC_XML_INVALID_DOCUMENT, 
  GC_XML_EMPTY_DOCUMENT, 
  GC_OBJECT_NOT_FOUND, 
  GC_CANT_READ_FROM_FILE, 
  GC_CHARSET_CONVERSION_ERROR,
  GC_CHARSET_WRONG_CHARSET_SPECIFIED
} TGCError;

typedef enum tagChangeReason
{
  GC_CHANGE_SELECTION_ADD,
  GC_CHANGE_SELECTION_CLEAR,
  GC_CHANGE_SELECTION_REMOVE
} TGCChangeReason;

typedef enum tagSelectionInfo
{
  GC_SI_NONE,
  GC_SI_ON_OBJECT,
  GC_SI_NORTH,
  GC_SI_NORTH_EAST,
  GC_SI_EAST,
  GC_SI_SOUTH_EAST,
  GC_SI_SOUTH,
  GC_SI_SOUTH_WEST,
  GC_SI_WEST,
  GC_SI_NORTH_WEST
} TGCSelectionInfo;

// TProperty is a list of all properties that can be set and queried in the canvas, figures etc. 
typedef enum tagProperty
{
  GC_PROPERTY_HANDLE_SIZE         // Size of the selection handles in the selection layer.
} TProperty;

typedef stdext::hash_map<string, unsigned char*> TColorMap;
typedef stdext::hash_map<string, unsigned char*>::iterator TColorMapIterator;
typedef pair<string, unsigned char*> TColorMapPair;

// A std::string comparation class, which does a case insensitive comparation.
class CStringLessThan
{
public:
  bool operator()(const string s1, const string s2) const
  {
    // Case insensitive comparation.
    return g_strcasecmp(s1.c_str(), s2.c_str()) < 0;
  }
};

//----------------------------------------------------------------------------------------------------------------------

#endif // __GC_GL_DATATYPES_H__