/***************************************************************************
                          gnumarkedfiles.h  -  description
                             -------------------
    begin                : Sun Jan 19 2003
    copyright            : (C) 2003 by Max Zaitsev
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef GNUMARKEDFILES_H
#define GNUMARKEDFILES_H

enum MarkedFileType {
    MFT_NoMatch       = 0,
    MFT_LibraryActual = 1,
    MFT_LibraryStored = 3,
    MFT_LibraryActMul = 7,
    MFT_Attempted     = 8,
    MFT_Partial       = 16,
    MFT_InDownload    = 32,
    MFT_User          = 128,
    // type mask
    MFT_All           = 0xfff,
    // matching result flags
    MFR_Flags    = 0xF000000,
    MFR_Exact    = 0x8000000,
    MFR_Probable = 0x4000000,
    MFR_PrbNoSha = 0x2000000,
    MFR_Possible = 0x1000000
};
// TODO: figure out type upgrade rules, that is if file was Downloaded and
//       then was found in library it changes type to LibraryActual, but not
//       the reverse. Most of upgrade rules will only apply to items with SHA1

struct SMarkedFile {
    set<CString>  setSearch; // set of space-separated search terms to match
    SHA1Hash sha1;           // SHA1 hash
    long     nHandle;        // integer handle for fast access (not unique)
    long     nSize;          // file size
    long     nType;          // see enum MarkedFileType
    long     nUpdateTime;    // self describing
};
typedef vector< SMarkedFile > tMFVec;

class MFileSizeClass {
	friend class MGnuMarkedFiles;
public:
	MFileSizeClass();

	void UpdateMaps();  // called after addition of an element
	void UpdateMaps(long nInd);  // called after modification of an element
	void RebuildMaps(); // called after element removal or multiple element addition
	long Match(const SHA1Hash& sha1, const CString& sSearch, long* pnMFIndex = NULL);
	
	void Remove(long nHandle, long nType);
	void AddFlag(long nHandle, long nType);
	
	inline int Size() { return vectorMF.size(); }

protected:
	tMFVec vectorMF;                                   // linear container for marked files
	
	map< SHA1Hash, long > mapSHA1_To_MFInd;            // maps hashes to indexes in vectorMF
	
	map< CString, long > mapWord_To_WIndex;            // maps keywords to abstract indexes
	long nNextWIndex;                                  // next free word index
	
	map< set<long>, list<long> > mapIndexSet_To_MFInd; // maps sets of word indexes to indexes in vectorMF
	
	map< long, set<long> > mapHandle_To_MFInd;        // maps handles to indexes in vectorMF

	void UpdateMapsForSingleElement(long nIndex, const SMarkedFile& mf);
	long GetFreeHandle();
};

class MGnuMarkedFiles {
public:
	typedef map< long, MFileSizeClass > tMap; 
	MGnuMarkedFiles();
	~MGnuMarkedFiles();
	bool AddFile(MarkedFileType type, long nSize, const SHA1Hash& sha1, const CString& sSearch, long nHandle = 0);
	bool RemoveFile(long nSize, const SHA1Hash& sha1, const CString& sSearch, bool removeAll = false);
	long MatchFile(long nSize, const SHA1Hash& sha1, const CString& sSearch);
	bool LoadList(const CString& sPath);
	bool StoreList(const CString& sPath);
	
	long GetFreeFileHandle(long nSize);
	bool AddFileFlag(long nSize, long nHandle, long nType);
	void RemoveFile(long nSize, long nHandle, long nType);
protected:
	tMap m_mapFiles; // Maps sizes to file entries.
	MMutex m_mutex;
};

#endif
