/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.output;

import base.drawable.Drawable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logformat.slog2.LineIDMap;
import logformat.slog2.TreeNodeID;
import logformat.slog2.output.OutputLog;
import logformat.slog2.output.TreeNode;

public class TreeTrunk {
    private OutputLog slog;
    private Map shadowdefs_map;
    private int num_leafs;
    private int leaf_bytesize;
    private List treenodes;
    private TreeNode leaf;
    private TreeNode root;
    private Drawable last_dobj_added;
    private LineIDMap lineIDmapOne;

    public TreeTrunk(OutputLog outputLog, Map map) {
        this.slog = outputLog;
        this.shadowdefs_map = map;
        this.num_leafs = this.slog.getNumChildrenPerNode();
        this.leaf_bytesize = this.slog.getTreeLeafByteSize();
        this.leaf = new TreeNode();
        this.leaf.setMapOfTopologyToShadowDef(this.shadowdefs_map);
        this.leaf.setTreeNodeID(new TreeNodeID(0, 0));
        this.treenodes = new LinkedList();
        this.treenodes.add(this.leaf);
        this.root = this.leaf;
        this.last_dobj_added = null;
        this.lineIDmapOne = null;
    }

    public void addDrawable(Drawable drawable) {
        if (this.leaf.getNodeByteSize() + drawable.getByteSize() > this.leaf_bytesize) {
            this.switchToNextBranch();
        }
        boolean bl = false;
        Iterator iterator = this.treenodes.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = (TreeNode)iterator.next();
            if (!(treeNode.getEarliestTime() <= drawable.getEarliestTime())) continue;
            treeNode.add(drawable);
            this.last_dobj_added = drawable;
            bl = true;
            break;
        }
        if (!bl) {
            this.root.add(drawable);
            this.last_dobj_added = drawable;
            bl = true;
            this.root.affectEarliestTime(drawable.getEarliestTime());
        }
    }

    private void switchToNextBranch() {
        TreeNode treeNode;
        TreeNodeID treeNodeID = new TreeNodeID(this.leaf.getTreeNodeID());
        treeNodeID.toNextSibling();
        Iterator iterator = this.treenodes.iterator();
        while (iterator.hasNext() && !(treeNode = (TreeNode)iterator.next()).getTreeNodeID().equals(treeNodeID)) {
            treeNode.finalizeLatestTime(this.last_dobj_added);
            this.slog.writeTreeNode(treeNode);
            treeNode.empty();
            double d = treeNode.getEarliestTime();
            treeNode.setEarliestTime(treeNode.getLatestTime());
            treeNode.setTreeNodeID(treeNodeID);
            treeNodeID.toParent(this.num_leafs);
            if (iterator.hasNext()) continue;
            this.root = new TreeNode(treeNode);
            this.root.setMapOfTopologyToShadowDef(this.shadowdefs_map);
            this.root.setTreeNodeID(treeNodeID);
            this.root.affectEarliestTime(d);
            this.treenodes.add(this.root);
            break;
        }
    }

    public void flushToFile() {
        Iterator iterator = this.treenodes.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = (TreeNode)iterator.next();
            treeNode.finalizeLatestTime(this.last_dobj_added);
            this.slog.writeTreeNode(treeNode);
            if (!iterator.hasNext()) {
                this.lineIDmapOne = treeNode.getIdentityLineIDMap();
            }
            treeNode.empty();
        }
        this.last_dobj_added = null;
    }

    public LineIDMap getIdentityLineIDMap() {
        return this.lineIDmapOne;
    }
}

