/*
 * BK Id: SCCS/s.unistd.h 1.15 02/03/03 15:42:49 benh
 */

#ifndef _H_SYSCALL
#define _H_SYSCALL

#ifndef BROKEN_SYSCALL

#define	_xsyscall1	_syscall1
#define	_xsyscall2	_syscall2
#define	_xsyscall3	_syscall3
#define	_xsyscall4	_syscall4
#define	_xsyscall5	_syscall5

#else /* BROKEN_SYSCALL */

#define __NR(n)	#n

/* On powerpc a system call basically clobbers the same registers like a
 * function call, with the exception of LR (which is needed for the
 * "sc; bnslr" sequence) and CR (where only CR0.SO is clobbered to signal
 * an error return status).
 */

#define __xsyscall_nr(nr, type, name, args...)				\
	unsigned long __xsc_ret, __xsc_err;				\
	{								\
		register unsigned long __xsc_0  __asm__ ("r0");		\
		register unsigned long __xsc_3  __asm__ ("r3");		\
		register unsigned long __xsc_4  __asm__ ("r4");		\
		register unsigned long __xsc_5  __asm__ ("r5");		\
		register unsigned long __xsc_6  __asm__ ("r6");		\
		register unsigned long __xsc_7  __asm__ ("r7");		\
									\
		__xsc_loadargs_##nr(name, args);			\
		__asm__ __volatile__					\
			("sc           \n\t"				\
			 "mfcr %0      "				\
			: "=&r" (__xsc_0),				\
			  "=&r" (__xsc_3),  "=&r" (__xsc_4),		\
			  "=&r" (__xsc_5),  "=&r" (__xsc_6),		\
			  "=&r" (__xsc_7)				\
			: __xsc_asm_input_##nr				\
			: "cr0", "ctr", "memory",			\
			  "r8", "r9", "r10","r11", "r12");		\
		__xsc_ret = __xsc_3;					\
		__xsc_err = __xsc_0;					\
	}								\
	if (__xsc_err & 0x10000000)					\
	{								\
		errno = __xsc_ret;					\
		__xsc_ret = -1;						\
	}								\
	return (type) __xsc_ret

#define __xsc_loadargs_0(name, dummy...)				\
	__xsc_0 = __NR_##name
#define __xsc_loadargs_1(name, arg1)					\
	__xsc_loadargs_0(name);						\
	__xsc_3 = (unsigned long) (arg1)
#define __xsc_loadargs_2(name, arg1, arg2)				\
	__xsc_loadargs_1(name, arg1);					\
	__xsc_4 = (unsigned long) (arg2)
#define __xsc_loadargs_3(name, arg1, arg2, arg3)			\
	__xsc_loadargs_2(name, arg1, arg2);				\
	__xsc_5 = (unsigned long) (arg3)
#define __xsc_loadargs_4(name, arg1, arg2, arg3, arg4)			\
	__xsc_loadargs_3(name, arg1, arg2, arg3);			\
	__xsc_6 = (unsigned long) (arg4)
#define __xsc_loadargs_5(name, arg1, arg2, arg3, arg4, arg5)		\
	__xsc_loadargs_4(name, arg1, arg2, arg3, arg4);			\
	__xsc_7 = (unsigned long) (arg5)

#define __xsc_asm_input_0 "0" (__xsc_0)
#define __xsc_asm_input_1 __xsc_asm_input_0, "1" (__xsc_3)
#define __xsc_asm_input_2 __xsc_asm_input_1, "2" (__xsc_4)
#define __xsc_asm_input_3 __xsc_asm_input_2, "3" (__xsc_5)
#define __xsc_asm_input_4 __xsc_asm_input_3, "4" (__xsc_6)
#define __xsc_asm_input_5 __xsc_asm_input_4, "5" (__xsc_7)

#define _xsyscall0(type,name)						\
type name(void)								\
{									\
	__xsyscall_nr(0, type, name);					\
}

#define _xsyscall1(type,name,type1,arg1)				\
type name(type1 arg1)							\
{									\
	__xsyscall_nr(1, type, name, arg1);				\
}

#define _xsyscall2(type,name,type1,arg1,type2,arg2)			\
type name(type1 arg1, type2 arg2)					\
{									\
	__xsyscall_nr(2, type, name, arg1, arg2);			\
}

#define _xsyscall3(type,name,type1,arg1,type2,arg2,type3,arg3)		\
type name(type1 arg1, type2 arg2, type3 arg3)				\
{									\
	__xsyscall_nr(3, type, name, arg1, arg2, arg3);			\
}

#define _xsyscall4(type,name,type1,arg1,type2,arg2,type3,arg3,type4,arg4) \
type name(type1 arg1, type2 arg2, type3 arg3, type4 arg4)		\
{									\
	__xsyscall_nr(4, type, name, arg1, arg2, arg3, arg4);		\
}

#define _xsyscall5(type,name,type1,arg1,type2,arg2,type3,arg3,type4,arg4,type5,arg5) \
type name(type1 arg1, type2 arg2, type3 arg3, type4 arg4, type5 arg5)	\
{									\
	__xsyscall_nr(5, type, name, arg1, arg2, arg3, arg4, arg5);	\
}
#endif	 /* BROKEN_SYSCALL */

#endif   /* _H_SYSCALL */
