  /* This function tests, whether the ISO 10646/Unicode character code
   * ucs should print right-to-left
   */

int
is_right_to_left (ucs)
  unsigned long ucs;
{
  if (ucs < 0x0590)
      return 0;

  return
     (ucs >= 0x0590 && ucs <= 0x05FF)	/* Hebrew */
  || (ucs >= 0xFB1D && ucs <= 0xFB4F)	/* Hebrew presentation forms */
  || (ucs >= 0x0600 && ucs <= 0x07BF)	/* Arabic, Syriac, Thaana */
  || (ucs >= 0xFB50 && ucs <= 0xFDFF)	/* Arabic presentation forms A */
  || (ucs >= 0xFE70 && ucs <= 0xFEFF)	/* Arabic presentation forms B */
  || (ucs == 0x200F)			/* right-to-left mark */
  || (ucs == 0x202B)			/* right-to-left embedding */
  || (ucs == 0x202E)			/* right-to-left override */
  ;
}
