/* pix_selection.c -- pixmaps configuration 
 *
 * Copyright(C) 2001-2002 Elisa Manara <e@entropika.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */ 

#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include "melon.h"

void set_melon_position (void);
void set_pix( GtkWidget		*clist,
		gint		row,
		GdkEventButton	*event );

gint select_pixmaps (GtkWidget *widget, gpointer data)
{
	GtkWidget *sel_window;
	GtkWidget *vbox;
	GtkWidget *scroll_win, *p_list;
	GtkWidget *button;
	GdkPixmap *gdk_pix1, *gdk_pix2;
	GdkBitmap *mask1, *mask2;
	GtkStyle *style;
	gchar *titles[3] = { "Style", "Default", "New Mail" };
	gchar *dir_data[3];
	int row = 0;
	int c;

	/* window */
	sel_window = gtk_window_new( GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW (sel_window), GTK_WIN_POS_MOUSE);
	gtk_widget_set_usize( GTK_WIDGET (sel_window), 240, 280);
	gtk_window_set_title(GTK_WINDOW (sel_window), "Pixmaps Selection");
	gtk_widget_show(sel_window);

	/* vbox */
	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( sel_window ), vbox );
	gtk_widget_show( vbox );

	/* scrolled window */
	scroll_win = gtk_scrolled_window_new( NULL, NULL );
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW( scroll_win ),  
		GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
	gtk_box_pack_start( GTK_BOX( vbox ), scroll_win, FALSE, FALSE, 0 );
	gtk_widget_show(scroll_win);

	/* clist for pixmaps selection */
	p_list = gtk_clist_new_with_titles (3, titles);

	gtk_signal_connect(GTK_OBJECT(p_list), "select_row",
		GTK_SIGNAL_FUNC(set_pix), NULL);

	gtk_widget_set_usize( GTK_WIDGET (p_list), 240, 240);
	gtk_clist_set_row_height( GTK_CLIST (p_list), 30);
	gtk_clist_column_titles_passive( GTK_CLIST( p_list ));
	gtk_clist_set_shadow_type (GTK_CLIST(p_list), GTK_SHADOW_OUT);
	gtk_clist_set_selection_mode( GTK_CLIST( p_list ),
		GTK_SELECTION_SINGLE);
	
	gtk_clist_set_column_width(GTK_CLIST( p_list ), 0, 90);
	gtk_clist_set_column_width(GTK_CLIST( p_list ), 1, 50);
	gtk_clist_set_column_width(GTK_CLIST( p_list ), 2, 50);

	gtk_container_add( GTK_CONTAINER( scroll_win ), p_list );

	/* insert pixmaps and text into clist */
	for(c = 0; c < MAX_STYLE_DIRS; c++)
	{
		if (p_data[c].pix_name[0] == '\0')
			break;

		dir_data[0] = p_data[c].pix_name;
		dir_data[1] = NULL;
		dir_data[2] = NULL;
		gtk_clist_append(GTK_CLIST (p_list), dir_data);

		style = gtk_widget_get_default_style();

		gdk_pix1 = gdk_pixmap_create_from_xpm( sel_window->window, &mask1,
			&style->bg[GTK_STATE_NORMAL],
			p_data[c].no_mail_pix);
		gdk_pix2 = gdk_pixmap_create_from_xpm( sel_window->window, &mask2,
			&style->bg[GTK_STATE_NORMAL],
			p_data[c].new_mail_pix);

		gtk_clist_set_pixmap(GTK_CLIST( p_list ), row, 1, gdk_pix1, mask1);
		gtk_clist_set_pixmap(GTK_CLIST( p_list ), row, 2, gdk_pix2, mask2);
		/* freep pixmaps */
		gdk_pixmap_unref(gdk_pix1);
		gdk_pixmap_unref(gdk_pix2);
		row++;
	}

	gtk_widget_show(p_list);

	/* CLOSE button */
	button = gtk_button_new_with_label ("Close");
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy),
		GTK_OBJECT (sel_window));
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	gtk_widget_show (button);

	return 1;
}

void set_pix( GtkWidget		*p_list,
		gint		row,
		GdkEventButton	*event )
{

	GdkBitmap *mask1, *mask2;
	GtkStyle *style;

	style = gtk_widget_get_default_style();

	if(!pixmap_exist(p_data[row].no_mail_pix) || !pixmap_exist(p_data[row].new_mail_pix)) {
		dialog_message(" Cannot load new pixmaps ");
		return;
	}

	/* free pixmaps */
	gdk_pixmap_unref(w_data.gdk_pixmap);
	gdk_pixmap_unref(w_data.new_gdk_pixmap);
	/* set new pixmaps */
	w_data.gdk_pixmap = gdk_pixmap_create_from_xpm( w_data.window->window, &mask1,
		&style->bg[GTK_STATE_NORMAL],
		p_data[row].no_mail_pix);
	w_data.new_gdk_pixmap = gdk_pixmap_create_from_xpm( w_data.window->window, &mask2,
		&style->bg[GTK_STATE_NORMAL],
		p_data[row].new_mail_pix);
	w_data.mask1 = mask1;
	w_data.mask2 = mask2;

	/* set icon position */
	set_melon_position();

	/* This masks out everything except for the image itself */
	if(none_active_mbox()) {
		gtk_widget_shape_combine_mask( w_data.window, w_data.mask1, 0, 0 );
		gtk_pixmap_set( GTK_PIXMAP(w_data.pixmap), w_data.gdk_pixmap, w_data.mask1 );

	} else {
		gtk_widget_shape_combine_mask( w_data.window, w_data.mask2, 0, 0 );
		gtk_pixmap_set( GTK_PIXMAP(w_data.pixmap), w_data.new_gdk_pixmap, w_data.mask2 );
	}

	strncpy(cfg_data.no_mail_pix, p_data[row].no_mail_pix, MAX_PLEN);
	strncpy(cfg_data.new_mail_pix, p_data[row].new_mail_pix, MAX_PLEN);

	/* update melon.cfg file for next startup */
	config_update();

	/* check_mbox ("new_selection"); */
}
