/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _cdrom_int_device_h_
#define _cdrom_int_device_h_

#include "mas/mas_dpi.h"
#include "mas_cdrom_common.h"

/* Track info */
struct track_info
{
	char			*trackname;	/* Trackname from online cddb database */
	char 			audio_track;	/* 1 if it's an audio track */
	char			number;		/* The audio track number */
	struct track_msf	start_msf;	/* The start of the track on the cd */
	struct track_msf	length_msf;	/* The length of the track */
};

/* Struct for containing data about a cd device */
struct cdrom_device
{
	int			instance;		/* The ID of the loaded device */
	int			dev_handle;		/* Dev handle returned by open */
	int32			reaction_port;		/* Reaction port to send data through MAS */

	char			*device_location;	/* String with the device name */
	int			status;			/* The status of the cd being played */
	int			current_track;		/* The current track being played */
	struct track_msf	absolute_msf;		/* Location on entire cd */
	struct track_msf	relative_msf;		/* Location on current track */
	
	int32			cddb_id;		/* The cddb ID */
	char			*cd_genre;		/* Genre of the cd */
	char			*cd_title;		/* Title of the cd */
	char			*cd_year;		/* Year of the cd */
	char			*cd_misc_data;		/* Misc data from the cddb database. */
	int			number_of_tracks;	/* The number of tracks on the cd */
	struct track_info	*tracks;		/* An array of all the tracks on the cd */

	struct cdrom_device	*next;			/* Next device in the linked list */
	struct cdrom_device	*prev;			/* Prev device in the linked list */
};

/* Major initalization of the device */
int32 mas_dev_init_library();

/* Initializes the cdrom. Takes a pointer to a string of the device location  */
int32 mas_dev_init_instance(int32 device_instance, void* predicate);

/* Closes and frees the cd device */
int32 mas_dev_exit_instance(int32 device_instance, void* predicate);

/* Major initalization of the device */
int32 mas_dev_exit_library();

/* Plays a given track number or set. */
int32 mas_cdrom_play_track(int32 device_instance, void* predicate);

/* Starts playing the track a location in seconds. */
int32 mas_cdrom_play_msf(int32 device_instance, void* predicate);

/* Sets the state of the cd player. */
int32 mas_cdrom_set_status(int32 device_instance, void* predicate);

/* Gets the state of the cd player. */
int32 mas_cdrom_get_status(int32 device_instance, void* predicate);

/* Gets the information about the cdrom. */
int32 mas_cdrom_get_info(int32 device_instance, void* predicate);

/* This fetches the cd's info from the freedb.org database */
int update_cddb_info(struct cdrom_device *cd_dev, char *username, char *servername);

/* Returns a pointer to the device with the given ID. */
struct cdrom_device *InstancetoCDDev(int instance);

/* Updates all the info of the cd and it's current playing status */
int mas_cdrom_update_status(struct cdrom_device *cd_dev);

/* Reads all the track info on the cd */
int mas_dev_read_track_info(struct cdrom_device* cd_dev);


#endif /* _cdrom_int_device_h_ */
