/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _MAS_INTERNAL_H
#define _MAS_INTERNAL_H

/***********************************************************************
 * mas_internal.h
 *
 * Internal functions accessible to the server and devices.
 ***********************************************************************/

#include <stdlib.h>
#include "mas/mas_constants.h"
#include "mas/mas_types.h"
#include "mas/mas_error.h"
#include "mas/mas_misc.h"
#include "mas/mas_common.h"
#include "assembler.h"

#define MAS_PRINT_LICENSE 0x01
#define MAS_PRINT_CMATRIX 0x02

/* This is temporary */
/* used to hold (key, value) pairs in unconstrained type lists */
struct mas_keyval  
{              
    char* key;
    char* value;
};

/***********************************************************************
 * internal device routines
 ***********************************************************************/
extern int32   masi_verify_mas_device( char* name );
extern char*   masi_get_value_from_key( struct mas_keyval* keyval_list, char* key );

/***********************************************************************
 * debugging stuff
 ***********************************************************************/
extern int32 masi_print_device_profile( struct mas_device_profile*, int flags  );
extern int32 masi_print_instantiated_devices( void );
extern int32 masi_print_ports( void );
extern void masi_print_loaded_device_libraries( void );
extern void masi_print_assemblages( void );
extern void masi_print_assemblage( struct mas_assemblage* asmb );
extern int32 masi_print_characteristic_matrix( struct mas_characteristic_matrix* cmatrix );
extern int32 masi_print_data_characteristic( struct mas_data_characteristic* dc );
extern int32 masi_print_event_queue( struct mas_event* head );
extern int32 masi_print_event( struct mas_event* event );
extern int32 masi_print_action_statistics( struct mas_stats* stat );
extern void masi_print_all_profiles( void );
extern void  masi_show_hex(char *buffer, int len);
extern void masi_dump_server_state( void );

#endif /* _MAS_INTERNAL_H */
