/****************************************************************************

COPYRIGHT NOTICE:

  The source code in this file is provided free of charge
  to the author's consulting clients.  It is in the
  public domain and therefore may be used by anybody for
  any purpose.

AUTHOR:

  Will Naylor

****************************************************************************/
#include "wnlib.h"
#include "wnrtab.h"

#include "wnhash.h"



int wn_strhash(register char *key)
{
  register int c,ret;
  register int *random_int_table;

  c = (int)(*key);

  if(c == (int)'\0')
  {
    return(0);   /* empty string */
  }
  else
  {
    random_int_table = wn_random_int_table + 260;

    ret = random_int_table[c];

    c = (int)(*(++key));

    if(c == (int)'\0')   /* single char string */
    {
      return(ret);   
    }
    else
    {
      do
      {
        ret += random_int_table[c];

        c = (int)(*(++key));
      }
      while(c != (int)'\0');

      return(ret);
    }
  }
}



