/*
 * Unicode Conversion Library (EUC-JP to UCS2)
 * 1997-2002 by yoshidam
 *
 */

#ifdef USE_EUC

#include <string.h>
#include "uconv.h"
#include "e2u.h"
#include "hojo2u.h"
#include "ustring.h"

int
e2u_conv2(const unsigned char* e, UString* u, unknown_euc unknown_e_conv)
{
  int i;
  int len = strlen((char*)e);

  UStr_alloc(u);

  for (i = 0; i < len; i++) {
    if (e[i] < 128) {	/* ASCII */
      UStr_addChar2(u, e[i], 0);
    }
    else if (e[i] == 0x8e) { /* JIS X 0201 kana */
      unsigned char ec = 0;
      if (e[i + 1] >= 0xa1 && e[i + 1] <= 0xdf)
	ec = e[i + 1] - 0x40;
      UStr_addChar2(u, ec, 0xff);
      i++;
    }
    else if (e[i] == 0x8f) { /* JIS X 0212 */
      int hi = e[i + 1] &  0x7f;
      int low = e[i + 2] &  0x7f;
      int key = (hi - 32) * 96 + (low - 32);
      unsigned short ec = 0;
      if (hi >= 32 && hi <= 127 && low >= 32 && low <= 127)
	ec = hojo2u_tbl[key];
      if (ec == 0) {
	ec = '?';
	if (unknown_e_conv != NULL) {
	  VALUE ret;
	  unsigned char ue[4];
	  ue[0] = e[i]; ue[1] = e[i+1]; ue[2] = e[i+2]; ue[3] = 0;
	  ret = unknown_e_conv(ue);
	  if (TYPE(ret) != T_FIXNUM) {
	    UStr_free(u);
	    rb_exc_raise(ret);
	  }
	  ec = FIX2INT(ret);
	}
      }
      UStr_addChar2(u, ec & 0xff, ec >> 8);
      i += 2;
    }
    else if (e[i] < 0xa0) {  /* C1 */
    }
    else {		     /* JIX X 0208 */
      int hi = e[i] &  0x7f;
      int low = e[i + 1] &  0x7f;
      int key = (hi - 32) * 96 + (low - 32);
      unsigned short ec = 0;
      if (hi >= 32 && hi <= 127 && low >= 32 && low <= 127)
	ec = e2u_tbl[key];
      if (ec == 0) {
	ec = '?';
	if (unknown_e_conv != NULL) {
	  VALUE ret;
	  unsigned char ue[3];
	  ue[0] = e[i]; ue[1] = e[i+1]; ue[2] = 0;
	  ret = unknown_e_conv(ue);
	  if (TYPE(ret) != T_FIXNUM) {
	    UStr_free(u);
	    rb_exc_raise(ret);
	  }
	  ec = FIX2INT(ret);
	}
      }
      UStr_addChar2(u, ec & 0xff, ec >> 8);
      i++;
    }
  }

  return u->len;
}

#endif /* USE_EUC */
