#ifndef CONFIG_H
#define CONFIG_H


/*
 *	Program name and version:
 */
#define PROG_NAME	"Joystick Calibrator"
#define PROG_VERSION	"1.5.0"

#define PROG_VERSION_MAJOR	1
#define PROG_VERSION_MINOR	5
#define PROG_VERSION_RELEASE	0


/*
 *	Program usage message:
 */
#define PROG_USAGE_MESG	"\
Usage: jscalibrator [options] [GUI_options]\n\
\n\
    [options] can be any of the following:\n\
\n\
        -d <device>            Specifies the initial joystick device to\n\
                               open at startup (default /dev/js0).\n\
        -f <file>              Specifies the joystick calibration file\n\
                               to open and save to (default ~/.joystick).\n\
        --help                 Prints (this) help screen and exits.\n\
        --version              Prints version information and exits.\n\
\n\
    [GUI_options] can be any options standard to your GUI, consult\n\
    your GUI's manual for available options.\n\
\n"


/*
 *	Copyright message:
 */
#define PROG_COPYRIGHT  "\
Copyright (C) 1997-2001 WolfPack Entertainment.\n\
This program is protected by international copyright laws and treaties,\n\
distribution and/or modification of this software in violation of the\n\
GNU Public License is strictly prohibited. Violators will be prosicuted\n\
to the fullest extent of the law."


/*
 *      Global data directory:
 */
#define JC_DATA_DIR     "/usr/share/libjsw"

/*
 *	Help files (JC_DATA_DIR will be prefixed).
 */
#define JC_HELP_FILE_INDEX		"help/index.html"
#define JC_HELP_FILE_INTRODUCTION	"help/introduction.html"
#define JC_HELP_FILE_HOW_TO_CALIBRATE	"help/how_to_calibrate.html"

/*
 *	Default toplevel size for JC window:
 */
#define JC_DEF_WIDTH	600
#define JC_DEF_HEIGHT	350

/*
 *	Default size of joystick button:
 */
#define JC_DEF_JS_BUTTON_WIDTH	80
#define JC_DEF_JS_BUTTON_HEIGHT	25

/*
 *	Default size of calibrate toggle button:
 */
#define JC_DEF_CALIBRATE_TOGGLE_WIDTH	80
#define JC_DEF_CALIBRATE_TOGGLE_HEIGHT	25


#endif	/* CONFIG_H */
