#line 45 "../noweb/g_rc.nw"
/* gEDA - GPL Electronic Design Automation
 * libgeda - gEDA's Library
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


#line 11 "../noweb/g_rc.nw"
/* DO NOT read or edit this file ! Use ../noweb/g_rc.nw instead */

#line 68 "../noweb/g_rc.nw"
#include <config.h>

#include <stdio.h>
#include <sys/stat.h>
#include <ctype.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_DIRENT_H
#include <dirent.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <gtk/gtk.h>
#include <libguile.h>

#include "defines.h"
#include "struct.h"
#include "globals.h"
#include "o_types.h"
#include "colors.h"

#include "../include/i_vars.h"
#include "../include/papersizes.h"
#include "../include/prototype.h"

#ifdef HAVE_LIBDMALLOC
#include <dmalloc.h>
#endif

extern GHashTable *font_char_to_file;


#line 119 "../noweb/g_rc.nw"
gint
g_rc_parse_general(TOPLEVEL * w_current,
		   const gchar * fname,
		   const gchar * ok_msg, const gchar * err_msg)
{
  gint found_rc = FALSE;
  GList *found_rc_filename_element;

  /* First see if fname is in list of previously read RC files. */
  found_rc_filename_element = g_list_find_custom(w_current->RC_list,
						 (gconstpointer) fname,
						 (GCompareFunc) strcmp);
  if (found_rc_filename_element != NULL) {
    /* We've already read this one in. */
    s_log_message("RC file [%s] already read in.\n", fname);
    return 0;
  }

  /* Now try to read in contents of RC file.  */
  if (access(fname, R_OK) == 0) {
    g_read_file(fname);
    found_rc = 1;
    /* Everything was OK.  Now add this file to list of read RC files. */
    w_current->RC_list = g_list_append(w_current->RC_list,
				       g_strdup(fname));
    s_log_message(ok_msg, fname);
  } else {
    found_rc = 0;
    s_log_message(err_msg, fname);
  }

  return found_rc;
}


#line 165 "../noweb/g_rc.nw"
const gchar *g_rc_parse_path()
{
  const gchar *rc_path;

  if (g_strcasecmp(GEDARCDIR, "none") == 0) {
    /* rc dir not specified at configure time, so search for config in */
    /* the normal GEDADATA directory */
    rc_path = g_getenv("GEDADATA");
  } else {
    /* rc path specified at configure time, always return specified path */
    rc_path = GEDARCDIR;
  }

  return (rc_path);
}

#line 192 "../noweb/g_rc.nw"
gint g_rc_parse_system_rc(TOPLEVEL * w_current, const gchar * rcname)
{
  const gchar *geda_data = g_getenv("GEDADATA");
  gint found_rc;
  gchar *tmp;
  char *filename;
  gchar *ok_msg, *err_msg;

  if (geda_data == NULL) {
    fprintf(stderr, "You must set the GEDADATA environment variable!\n");
    exit(-1);
  }

  tmp = g_strconcat(g_rc_parse_path(),
		    G_DIR_SEPARATOR_S, "system-", rcname, NULL);
  filename = f_normalize_filename(tmp);
  if (filename == NULL) {
    return 0;
  }

  ok_msg = g_strdup_printf("Read system-%s file [%%s]\n", rcname);
  err_msg = g_strdup_printf("Did not find required system-%s file [%%s]\n",
			    rcname);
  found_rc = g_rc_parse_general(w_current, filename, ok_msg, err_msg);

  g_free(ok_msg);
  g_free(err_msg);
  g_free(tmp);
  free(filename);

  return found_rc;
}


#line 240 "../noweb/g_rc.nw"
gint g_rc_parse_home_rc(TOPLEVEL * w_current, const gchar * rcname)
{
  const gchar *home = g_getenv("HOME");
  gint found_rc;
  gchar *tmp;
  char *filename;
  gchar *ok_msg, *err_msg;

  if (home == NULL) {
    return 0;
  }

  tmp = g_strconcat(home,
		    G_DIR_SEPARATOR_S,
		    ".gEDA", G_DIR_SEPARATOR_S, rcname, NULL);
  filename = f_normalize_filename(tmp);
  if (filename == NULL) {
    return 0;
  }

  ok_msg = g_strdup_printf("Read ~/.gEDA/%s file [%%s]\n", rcname);
  err_msg =
      g_strdup_printf("Did not find optional ~/.gEDA/%s file [%%s]\n",
		      rcname);
  found_rc = g_rc_parse_general(w_current, filename, ok_msg, err_msg);

  g_free(ok_msg);
  g_free(err_msg);
  g_free(tmp);
  free(filename);

  return found_rc;
}


#line 289 "../noweb/g_rc.nw"
gint g_rc_parse_local_rc(TOPLEVEL * w_current, const gchar * rcname)
{
  gint found_rc;
  gchar *tmp;
  char *filename;
  gchar *ok_msg;
  gchar *err_msg;

  tmp = g_strconcat(".", G_DIR_SEPARATOR_S, rcname, NULL);
  filename = f_normalize_filename(tmp);
  if (filename == NULL) {
    return 0;
  }

  ok_msg = g_strdup_printf("Read local %s file [%%s]\n", rcname);
  err_msg = g_strdup_printf("Did not find optional local %s file [%%s]\n",
			    rcname);
  found_rc = g_rc_parse_general(w_current, filename, ok_msg, err_msg);

  g_free(ok_msg);
  g_free(err_msg);
  g_free(tmp);
  free(filename);

  return found_rc;
}


#line 330 "../noweb/g_rc.nw"
gint g_rc_parse_specified_rc(TOPLEVEL * w_current, const gchar * rcname)
{
  gint found_rc = 0;
  char *filename;
  gchar *ok_msg;
  gchar *err_msg;

  if (rcname == NULL) {
    return 0;
  }

  filename = f_normalize_filename(rcname);

  ok_msg = g_strdup_printf("Read specified %s file [%%s]\n", rcname);
  err_msg = g_strdup_printf("Did not find specified %s file [%%s]\n",
			    rcname);
  found_rc = g_rc_parse_general(w_current, filename, ok_msg, err_msg);

  g_free(ok_msg);
  g_free(err_msg);
  free(filename);

  return found_rc;
}

#line 367 "../noweb/g_rc.nw"
void
g_rc_parse(TOPLEVEL * w_current,
	   const gchar * rcname, const gchar * specified_rc_filename)
{
  gint found_rc = 0;
  char *rc_path;
  char *geda_rcdata;

  /* set the GEDADATARC environment variable so that the rc files */
  /* know where to look for others */
  rc_path = f_normalize_filename(g_rc_parse_path());
  /* Reversion to putenv inspired by W. Hoch, 2.17.2005 */
  /*  g_setenv ("GEDADATARC", rc_path, TRUE); *//*requires glib 2.4.x */
  geda_rcdata = g_strdup_printf("GEDADATARC=%s", rc_path);
  putenv(geda_rcdata);
  free(rc_path);

  /* visit rc files in order */
  /* Changed by SDB 1.2.2005 in response to Peter Kaiser's bug report.
   * Read gafrc files first */
  found_rc |= g_rc_parse_system_rc(w_current, "gafrc");
  found_rc |= g_rc_parse_home_rc(w_current, "gafrc");
  found_rc |= g_rc_parse_local_rc(w_current, "gafrc");
  /* continue support for individual rc files for each program.  */
  found_rc |= g_rc_parse_system_rc(w_current, rcname);
  found_rc |= g_rc_parse_home_rc(w_current, rcname);
  found_rc |= g_rc_parse_local_rc(w_current, rcname);

  /* New fcn introduced by SDB to consolidate this & make it available 
   * for other programs */
  found_rc |= g_rc_parse_specified_rc(w_current, specified_rc_filename);

  /* Oh well, I couldn't find any rcfile, exit! */
  if (!found_rc) {
    /* TODO: these two are basically the
     * same. Inefficient! */
    s_log_message("Could not find any %s file!\n", rcname);
    fprintf(stderr, "Could not find a %s file\n", rcname);
    exit(-1);
  }
}



#line 420 "../noweb/g_rc.nw"
SCM g_rc_component_library(SCM path)
{
  char *string;

  SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path,
	     SCM_ARG1, "component-library");

  string = g_strdup(SCM_STRING_CHARS(path));
  /* take care of any shell variables */
  string = expand_env_variables(string);

  /* invalid path? */
  if (!g_file_test(string, G_FILE_TEST_IS_DIR)) {
    fprintf(stderr,
	    "Invalid path [%s] passed to component-library\n", string);
    free(string);
    return SCM_BOOL_F;
  }

  if (g_path_is_absolute(string)) {
    s_clib_add_directory(string);
  } else {
    gchar *cwd = g_get_current_dir();
    gchar *temp;
#ifdef __MINGW32__
    u_basic_strip_trailing(cwd, G_DIR_SEPARATOR);
#endif
    temp = g_strconcat(cwd, G_DIR_SEPARATOR_S, string, NULL);
    s_clib_add_directory(temp);
    g_free(temp);
    g_free(cwd);
  }

  if (string) {
    free(string);
  }

  return SCM_BOOL_T;
}


#line 472 "../noweb/g_rc.nw"
SCM g_rc_component_library_search(SCM path)
{
  char *string;
  GDir *dir;
  const gchar *entry;

  SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path,
	     SCM_ARG1, "component-library-search");

  string = g_strdup(SCM_STRING_CHARS(path));
  /* take care of any shell variables */
  string = expand_env_variables(string);

  /* invalid path? */
  if (!g_file_test(string, G_FILE_TEST_IS_DIR)) {
    fprintf(stderr,
	    "Invalid path [%s] passed to component-library-search\n",
	    string);
    free(string);
    return SCM_BOOL_F;
  }

  dir = g_dir_open(string, 0, NULL);
  if (dir == NULL) {
    fprintf(stderr,
	    "Invalid path [%s] passed to component-library-search\n",
	    string);
    free(string);
    return SCM_BOOL_F;
  }

  while ((entry = g_dir_read_name(dir))) {
    /* don't do . and .. and special case font */
    if ((g_strcasecmp(entry, ".") != 0) &&
	(g_strcasecmp(entry, "..") != 0) &&
	(g_strcasecmp(entry, "font") != 0)) {
      gchar *fullpath = g_strconcat(string,
				    G_DIR_SEPARATOR_S,
				    entry,
				    NULL);

      if (g_file_test(fullpath, G_FILE_TEST_IS_DIR)) {
	if (g_path_is_absolute(fullpath)) {
	  s_clib_add_directory(fullpath);
	} else {
	  gchar *cwd = g_get_current_dir();
	  gchar *temp;
#ifdef __MINGW32__
	  u_basic_strip_trailing(cwd, G_DIR_SEPARATOR);
#endif
	  temp = g_strconcat(cwd, G_DIR_SEPARATOR_S, fullpath, NULL);
	  s_clib_add_directory(temp);
	  g_free(temp);
	  g_free(cwd);
	}
      }
      g_free(fullpath);
    }
  }

  if (string) {
    free(string);
  }

  return SCM_BOOL_T;
}


#line 555 "../noweb/g_rc.nw"
SCM g_rc_source_library(SCM path)
{
  char *string;

  SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path,
	     SCM_ARG1, "source-library");

  string = g_strdup(SCM_STRING_CHARS(path));
  /* take care of any shell variables */
  string = expand_env_variables(string);

  /* invalid path? */
  if (!g_file_test(string, G_FILE_TEST_IS_DIR)) {
    fprintf(stderr,
	    "Invalid path [%s] passed to source-library\n", string);
    free(string);
    return SCM_BOOL_F;
  }

  if (g_path_is_absolute(string)) {
    s_slib_add_entry(string);
  } else {
    gchar *cwd = g_get_current_dir();
    gchar *temp;
#ifdef __MINGW32__
    u_basic_strip_trailing(cwd, G_DIR_SEPARATOR);
#endif
    temp = g_strconcat(cwd, G_DIR_SEPARATOR_S, string, NULL);
    s_slib_add_entry(temp);
    g_free(temp);
    g_free(cwd);
  }

  if (string) {
    free(string);
  }

  return SCM_BOOL_T;
}


#line 611 "../noweb/g_rc.nw"
SCM g_rc_source_library_search(SCM path)
{
  char *string;
  GDir *dir;
  const gchar *entry;

  SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path,
	     SCM_ARG1, "source-library-search");

  string = g_strdup(SCM_STRING_CHARS(path));
  /* take care of any shell variables */
  string = expand_env_variables(string);

  /* invalid path? */
  if (!g_file_test(string, G_FILE_TEST_IS_DIR)) {
    fprintf(stderr,
	    "Invalid path [%s] passed to source-library-search\n", string);
    free(string);
    return SCM_BOOL_F;
  }

  dir = g_dir_open(string, 0, NULL);
  if (dir == NULL) {
    fprintf(stderr,
	    "Invalid path [%s] passed to source-library-search\n", string);
    if (string) {
      free(string);
    }
    return SCM_BOOL_F;
  }

  while ((entry = g_dir_read_name(dir))) {
    /* don't do . and .. and special case font */
    if ((g_strcasecmp(entry, ".") != 0) &&
	(g_strcasecmp(entry, "..") != 0) &&
	(g_strcasecmp(entry, "font") != 0)) {
      gchar *fullpath = g_strconcat(string,
				    G_DIR_SEPARATOR_S,
				    entry,
				    NULL);

      if (g_file_test(fullpath, G_FILE_TEST_IS_DIR)) {
	if (s_slib_uniq(fullpath)) {
	  if (g_path_is_absolute(fullpath)) {
	    s_slib_add_entry(fullpath);
	  } else {
	    gchar *cwd = g_get_current_dir();
	    gchar *temp;
#ifdef __MINGW32__
	    u_basic_strip_trailing(cwd, G_DIR_SEPARATOR);
#endif
	    temp = g_strconcat(cwd, G_DIR_SEPARATOR_S, fullpath, NULL);
	    s_slib_add_entry(temp);
	    g_free(temp);
	    g_free(cwd);
	  }
	}
      }
      g_free(fullpath);
    }
  }

  if (string) {
    free(string);
  }

  return SCM_BOOL_T;
}


#line 698 "../noweb/g_rc.nw"
SCM g_rc_world_size(SCM width, SCM height, SCM border)
#define FUNC_NAME "world-size"
{
  int i_width, i_height, i_border;
  int init_right, init_bottom;

  SCM_ASSERT(SCM_NIMP(width) && SCM_REALP(width), width,
	     SCM_ARG1, FUNC_NAME);
  SCM_ASSERT(SCM_NIMP(height) && SCM_REALP(height), height,
	     SCM_ARG2, FUNC_NAME);
  SCM_ASSERT(SCM_NIMP(border) && SCM_REALP(border), border,
	     SCM_ARG3, FUNC_NAME);

  /* yes this is legit, we are casing the resulting double to an int */
  i_width = (int) (SCM_NUM2DOUBLE(0, width) * MILS_PER_INCH);
  i_height = (int) (SCM_NUM2DOUBLE(0, height) * MILS_PER_INCH);
  i_border = (int) (SCM_NUM2DOUBLE(0, border) * MILS_PER_INCH);

  PAPERSIZEtoWORLD(i_width, i_height, i_border, &init_right, &init_bottom);

#if DEBUG
  printf("%d %d\n", i_width, i_height);
  printf("%d %d\n", init_right, init_bottom);
#endif

  default_init_right = init_right;
  default_init_bottom = init_bottom;

  return SCM_BOOL_T;
}

#undef FUNC_NAME



#line 743 "../noweb/g_rc.nw"
SCM g_rc_default_series_name(SCM name)
{
  SCM_ASSERT(SCM_NIMP(name) && SCM_STRINGP(name), name,
	     SCM_ARG1, "default-series-name");

  if (default_series_name) {
    free(default_series_name);
  }

  default_series_name = g_strdup(SCM_STRING_CHARS(name));

  return SCM_BOOL_T;
}


#line 769 "../noweb/g_rc.nw"
SCM g_rc_untitled_name(SCM name)
{
  SCM_ASSERT(SCM_NIMP(name) && SCM_STRINGP(name), name,
	     SCM_ARG1, "untitled-name");

  if (default_untitled_name) {
    free(default_untitled_name);
  }

  default_untitled_name = g_strdup(SCM_STRING_CHARS(name));

  return SCM_BOOL_T;
}


#line 795 "../noweb/g_rc.nw"
SCM g_rc_font_directory(SCM path)
{
  char *string;

  SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path,
	     SCM_ARG1, "font-directory");

  string = g_strdup(SCM_STRING_CHARS(path));
  /* take care of any shell variables */
  string = expand_env_variables(string);

  /* invalid path? */
  if (!g_file_test(string, G_FILE_TEST_IS_DIR)) {
    fprintf(stderr,
	    "Invalid path [%s] passed to font-directory\n", string);
    if (string) {
      free(string);
    }
    return SCM_BOOL_F;
  }

  if (default_font_directory) {
    free(default_font_directory);
  }
  default_font_directory = string;

  return SCM_BOOL_T;
}


#line 837 "../noweb/g_rc.nw"
SCM g_rc_scheme_directory(SCM path)
{
  char *string;

  SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path,
	     SCM_ARG1, "scheme-directory");

  string = g_strdup(SCM_STRING_CHARS(path));
  /* take care of any shell variables */
  string = expand_env_variables(string);

  /* invalid path? */
  if (!g_file_test(string, G_FILE_TEST_IS_DIR)) {
    fprintf(stderr,
	    "Invalid path [%s] passed to scheme-directory\n", string);
    if (string) {
      free(string);
    }
    return SCM_BOOL_F;
  }

  if (default_scheme_directory) {
    free(default_scheme_directory);
  }
  default_scheme_directory = string;

  return SCM_BOOL_T;
}


#line 879 "../noweb/g_rc.nw"
SCM g_rc_bitmap_directory(SCM path)
{
  char *string;

  SCM_ASSERT(SCM_NIMP(path) && SCM_STRINGP(path), path,
	     SCM_ARG1, "bitmap-directory");

  string = g_strdup(SCM_STRING_CHARS(path));
  /* take care of any shell variables */
  string = expand_env_variables(string);

  /* invalid path? */
  if (!g_file_test(string, G_FILE_TEST_IS_DIR)) {
    fprintf(stderr,
	    "Invalid path [%s] passed to bitmap-directory\n", string);
    if (string) {
      free(string);
    }
    return SCM_BOOL_F;
  }

  if (default_bitmap_directory) {
    free(default_bitmap_directory);
  }
  default_bitmap_directory = string;

  return SCM_BOOL_T;
}


#line 921 "../noweb/g_rc.nw"
SCM g_rc_bus_ripper_symname(SCM scmsymname)
{
  SCM_ASSERT(SCM_NIMP(scmsymname) && SCM_STRINGP(scmsymname), scmsymname,
	     SCM_ARG1, "bus-ripper-symname");

  if (default_bus_ripper_symname) {
    free(default_bus_ripper_symname);
  }
  default_bus_ripper_symname = g_strdup(SCM_STRING_CHARS(scmsymname));

  return SCM_BOOL_T;
}



#line 946 "../noweb/g_rc.nw"
SCM g_rc_reset_component_library(void)
{
  s_clib_init();

  return SCM_BOOL_T;
}


#line 965 "../noweb/g_rc.nw"
SCM g_rc_reset_source_library(void)
{
  s_slib_free();
  s_slib_init();

  return SCM_BOOL_T;
}



#line 983 "../noweb/g_rc.nw"
SCM g_rc_map_font_character_to_file(SCM scmcharstr, SCM scmfilename)
{
  gchar *charstr, *filename;
  gunichar character;

  SCM_ASSERT(SCM_STRINGP(scmcharstr), scmcharstr,
	     SCM_ARG1, "map-font-character-to-file");
  SCM_ASSERT(SCM_STRINGP(scmfilename), scmfilename,
	     SCM_ARG2, "map-font-character-to-file");

  charstr = SCM_STRING_CHARS(scmcharstr);
  filename = SCM_STRING_CHARS(scmfilename);

  if (charstr == NULL || filename == NULL) {
    fprintf(stderr,
	    "%s requires two strings as parameters\n",
	    "map-font-character-to-file");
    return SCM_BOOL_F;
  }

  /* take care of expansion of any shell variables in filename */
  filename = expand_env_variables(g_strdup(filename));

  character = g_utf8_get_char_validated(charstr, -1);

  /* insert the new character declaration in the hash table */
  g_hash_table_insert(font_char_to_file,
		      GUINT_TO_POINTER((guint) character), filename);

  return SCM_BOOL_T;
}
