/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.set;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class MapBackedSet
implements Set,
Serializable {
    private static final long serialVersionUID = 6723912213766056587L;
    protected final Map map;
    protected final Object dummyValue;

    public static final Set decorate(Map map) {
        return MapBackedSet.decorate(map, null);
    }

    public static final Set decorate(Map map, Object dummyValue) {
        if (map == null) {
            throw new IllegalArgumentException("The map must not be null");
        }
        return new MapBackedSet(map, dummyValue);
    }

    public final int size() {
        return this.map.size();
    }

    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    public final Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public final boolean contains(Object obj) {
        return this.map.containsKey(obj);
    }

    public final boolean containsAll(Collection coll) {
        return this.map.keySet().containsAll(coll);
    }

    public final boolean add(Object obj) {
        int size = this.map.size();
        this.map.put(obj, this.dummyValue);
        boolean bl = false;
        if (this.map.size() != size) {
            bl = true;
        }
        return bl;
    }

    public final boolean addAll(Collection coll) {
        int size = this.map.size();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            this.map.put(obj, this.dummyValue);
        }
        boolean bl = false;
        if (this.map.size() != size) {
            bl = true;
        }
        return bl;
    }

    public final boolean remove(Object obj) {
        int size = this.map.size();
        this.map.remove(obj);
        boolean bl = false;
        if (this.map.size() != size) {
            bl = true;
        }
        return bl;
    }

    public final boolean removeAll(Collection coll) {
        return this.map.keySet().removeAll(coll);
    }

    public final boolean retainAll(Collection coll) {
        return this.map.keySet().retainAll(coll);
    }

    public final void clear() {
        this.map.clear();
    }

    public final Object[] toArray() {
        return this.map.keySet().toArray();
    }

    public final Object[] toArray(Object[] array) {
        return this.map.keySet().toArray(array);
    }

    public final boolean equals(Object obj) {
        return this.map.keySet().equals(obj);
    }

    public final int hashCode() {
        return this.map.keySet().hashCode();
    }

    private MapBackedSet(Map map, Object dummyValue) {
        this.map = map;
        this.dummyValue = dummyValue;
    }
}

