# $Id: kde.m4,v 1.2 2002/10/29 00:39:36 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# These functions search for KDE 2-3


AC_DEFUN(AQ_CHECK_KDE,[
dnl PREREQUISITES:
dnl   none
dnl IN: 
dnl   $1 = "yes" if KDE is needed, "no" if KDE is optional
dnl   $2 = subdirs to include when KDE is available
dnl   You may preset the return variables.
dnl   All variables which already have a value will not be altered
dnl OUT:
dnl   Variables:
dnl     have_kde - set to "yes" if KDE exists
dnl     kde_includes - path to includes
dnl     kde_libs - path to libraries
dnl     kde_app - kde apps given as the argument to this funtion
dnl     kde_install_dir - install directory for kde3 applications
dnl     kde_generation - major version of kde
dnl     qt_generation - major version of qt
dnl   Defines:
dnl     HAVE_KDE
dnl USED MACROS:
dnl  AQ_CHECK_KDE2
dnl  AQ_CHECK_KDE3


kde_local_ops="$1"
kde_local_lsd="$2"

dnl check if kde apps are desired
AC_MSG_CHECKING(if KDE applications should be compiled)
AC_ARG_ENABLE(kde,
  [  --enable-kde         enable compilation of kde applications (default=yes)],
  enable_kdeapps="$enableval",
  enable_kdeapps="yes")
AC_MSG_RESULT($enable_kdeapps)

if test "$enable_kdeapps" = "no"; then
   kde_libs=""
   kde_includes=""
   kde_app=""
   have_kde="no"
else
   dnl check for KDE3
   have_kde="no"
   have_kde3="no"
   AQ_CHECK_KDE3("no","$kde_local_lsd")
   if test "$have_kde3" = "yes"; then
   	kde_app="$kde3_app"
        kde_libs="$kde3_libs"
        kde_includes="$kde3_includes"
        kde_include_dir="$kde3_include_dir"
        kde_install_dir="$kde3_install_dir"
        kde_generation="3"
        qt_generation="3"
        have_kde="yes"
   	qt_app="$qt3_app"
        qt_libs="$qt3_libs"
        qt_includes="$qt3_includes"
   	qt_moc="$qt3_moc"
   	qt_uic="$qt3_uic"
        qt_generation="3"
        have_qt="yes"
   else
   	dnl check for KDE2
   	have_kde2="no"
   	AQ_CHECK_KDE2("no","$kde_local_lsd")
   	if test "$have_kde2" = "yes"; then
   		kde_app="$kde2_app"
        	kde_libs="$kde2_libs"
        	kde_includes="$kde2_includes"
        	kde_include_dir="$kde2_include_dir"
        	kde_install_dir="$kde2_install_dir"
        	kde_generation="2"
        	qt_generation="2"
        	have_kde="yes"
   		qt_app="$qt2_app"
        	qt_libs="$qt2_libs"
        	qt_includes="$qt2_includes"
   		qt_moc="$qt2_moc"
   		qt_uic="$qt2_uic"
        	qt_generation="2"
        	have_qt="yes"
   	fi
   fi
   dnl check if kde found
   AC_MSG_CHECKING(for KDE version to be used)
   if test "$have_kde" != "yes"; then
   	if test "$kde_local_ops" = "yes"; then
        	AC_MSG_ERROR([
  I could not find a suitable KDE version while checking for KDE2 and KDE3.
  If you do not want KDE applications to be compiled please use 
  --disable-kde.])
  	else
        	AC_MSG_RESULT(none)
   	fi
   else
   	AC_MSG_RESULT(version $kde_generation)
        AC_DEFINE(HAVE_KDE)
        AC_DEFINE_UNQUOTED(KDE_GENERATION,$kde_generation)
        AC_DEFINE_UNQUOTED(QT_GENERATION,$qt_generation)
   fi
dnl end of if "$enable_kdeapps"
fi

AC_SUBST(kde_app)
AC_SUBST(kde_libs)
AC_SUBST(kde_includes)
AC_SUBST(kde_include_dir)
AC_SUBST(kde_generation)
AC_SUBST(kde_install_dir)
AC_SUBST(qt_app)
AC_SUBST(qt_libs)
AC_SUBST(qt_includes)
AC_SUBST(qt_moc)
AC_SUBST(qt_uic)
AC_SUBST(qt_generation)
])

