/* -*- indent-tabs-mode: t; tab-width: 8; c-basic-offset: 8; -*- */

#include "libburn/libburn.h"
#include "libburn/toc.h"
#include "libburn/mmc.h"

#include <unistd.h>
#include <stdio.h>
#include <assert.h>

static struct burn_drive_info *drives;
static unsigned int n_drives;

static void poll_drive(int d)
{
	enum burn_disc_status s;

	fprintf(stderr, "polling disc in %s - %s:\n",
		drives[d].vendor, drives[d].product);

	if (!burn_drive_grab(drives[d].drive, 1)) {
		fprintf(stderr, "Unable to open the drive!\n");
		return;
	}

	while (burn_drive_get_status(drives[d].drive, NULL))
		usleep(1000);

	while ((s = burn_disc_get_status(drives[d].drive))
	       == BURN_DISC_UNREADY)
		usleep(1000);

	while (1) {
		sleep(2);
		mmc_get_event(drives[d].drive);
	}
	burn_drive_release(drives[d].drive, 0);
}

int main()
{
	fprintf(stderr, "Initializing library...");
	if (burn_initialize())
		fprintf(stderr, "Success\n");
	else {
		printf("Failed\n");
		return 1;
	}

	fprintf(stderr, "Scanning for devices...");
	while (!burn_drive_scan(&drives, &n_drives)) ;
	fprintf(stderr, "Done\n");

	poll_drive(2);
	burn_drive_info_free(drives);
	burn_finish();
	return 0;
}
