#include "apr.h"
#include "apr_errno.h"
#include "apr_pools.h"
#include "apr_dso.h"
#include "apr_strings.h"
#include "httpd.h"
#include "http_config.h"
#include "http_log.h"

#include "mod_xmlrpc_server.h"
#include "mod_xmlrpc_c.h"
#include "mod_xmlrpc.h"

#include <stdio.h>

struct mod_xmlrpc_dso
{
	struct apr_dso_handle_t *handle;
	struct mod_xmlrpc_func *func;
};

extern module AP_MODULE_DECLARE_DATA xmlrpc_module;

int mod_xmlrpc_dso_add(struct mod_xmlrpc_dso *mod,
		const char *filename, apr_pool_t *p)
{
	struct mod_xmlrpc_func *func;
	apr_dso_handle_sym_t sym;
	apr_dso_handle_t *handle;
	apr_status_t stat;

	stat = apr_dso_load(&handle, filename, p);
	if (stat != APR_SUCCESS) {
		char buf[256];
		apr_dso_error(handle, buf, sizeof(buf));
		fprintf(stderr, "%s\n", buf);
		return stat;
	}

	stat = apr_dso_sym(&sym, handle, "mod_xmlrpc_register");
	if (stat == APR_SUCCESS) {
		func = (struct mod_xmlrpc_func *) sym;
		while (func->module) {
			mod->handle = handle;
			mod->func = func;
			func++;
		}
	}
	else 
		apr_dso_unload(handle);

	return stat;
}

static void register_xmlrpc_stuff(struct mod_xmlrpc_dso *mod,
		void *registry, cmd_parms *parms)
{
	struct mod_xmlrpc_func *func;
	char name[256];

	func = mod->func;
	apr_snprintf(name, sizeof(name), "%s.%s", func->module, func->method);
	if (!mod_xmlrpc_server_register(registry, name, func->callback, func->user_data, func->signature, func->help))
		ap_log_error(APLOG_MARK, APLOG_WARNING, 0,
				parms->server, "Could not register callback: %s", name);
}

const char *c_set_xmlrpc_dir(cmd_parms *parms, void *ign, char *dir)
{
	void *registry;
	apr_status_t stat;
	apr_finfo_t info;
	apr_int32_t wanted;
	apr_dir_t *d;
	char fname[APR_PATH_MAX];
	struct mod_xmlrpc_dso mod;
	
	registry = ap_get_module_config(parms->server->module_config, &xmlrpc_module);
	stat = apr_dir_open(&d, dir, parms->temp_pool);
	if (stat != APR_SUCCESS)
		return "Error opening directory!";

	wanted = APR_FINFO_NAME | APR_FINFO_TYPE;
	while ((stat = apr_dir_read(&info, wanted, d)) == APR_SUCCESS) {
		if ((info.filetype != APR_REG && info.filetype != APR_LNK) ||
				info.name[0] == '.' || info.name[0] == '\0')
			continue;

		apr_snprintf(fname, sizeof(fname), "%s/%s", dir, info.name);
		if (mod_xmlrpc_dso_add(&mod, fname, parms->pool) != APR_SUCCESS)
			ap_log_error(APLOG_MARK, APLOG_WARNING, 0,
					parms->server, "Could not load or find symbols from file: %s", fname);
		else {
			register_xmlrpc_stuff(&mod, registry, parms);
		}
	}

	apr_dir_close(d);
	return NULL;
}
