/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include "parameter.h"
#include "crxchannel.h"
#include <qdatetime.h>
#include <qfile.h>
#include <qtextstream.h>


extern Parameter settings;
void QSOData::init()
{
 if(settings.QslData)
 {
  RemoteCallsign->setText(settings.QslData->RemoteCallsign);
  OpName->setText(settings.QslData->OpName);
  Qth->setText(settings.QslData->Qth);
  Locator->setText(settings.QslData->Locator);
  QsoFrequency->setText(settings.QslData->QsoFrequency);
  HisRST->setText(settings.QslData->HisRST);
  MyRST->setText(settings.QslData->MyRST);
  QsoDate->setText(settings.QslData->QsoDate);
  QsoTime->setText(settings.QslData->QsoTime);  
 }

}


void QSOData::clear()
{
 RemoteCallsign->setText("");
 OpName->setText("");
 Qth->setText("");
 Locator->setText("");
 QsoFrequency->setText("");
 HisRST->setText("");
 MyRST->setText("");
 QsoDate->setText("");
 QsoTime->setText("");
}

void QSOData::Callsignchanged()
{
 settings.QslData->RemoteCallsign=RemoteCallsign->text();
}

void QSOData::Namechanged()
{
 settings.QslData->OpName=OpName->text();
}

void QSOData::QTHchanged()
{
 settings.QslData->Qth=Qth->text();

}

void QSOData::Locatorchanged()
{
 settings.QslData->Locator=Locator->text();
}

void QSOData::Frequencychanged()
{
 settings.QslData->QsoFrequency=QsoFrequency->text();
}

void QSOData::HisRSTchanged()
{
 settings.QslData->HisRST=HisRST->text();
}

void QSOData::MyRSTchanged()
{
 settings.QslData->MyRST=MyRST->text();
}

void QSOData::Datechanged()
{
 settings.QslData->QsoDate=QsoDate->text();
}

void QSOData::Timechanged()
{
 settings.QslData->QsoTime=QsoTime->text();
}




void QSOData::refreshDateTime()
{
 QDateTime t1;
 QDateTime t;
 t=QDateTime::currentDateTime();

 t1=t.addSecs(settings.timeoffset*3600);

 QsoDate->setText(t.toString("d.MM.yyyy"));
 QsoTime->setText(t1.toString("h:mm"));
 settings.QslData->QsoTime=QsoTime->text();
 settings.QslData->QsoDate=QsoDate->text();
}


void QSOData::save()
{
if (settings.QSOFileName == "" || RemoteCallsign->text() =="")
 return ; // No Filename specified, or nothing relevant to store
// Get the most recent values
Callsignchanged();
//Namechanged(); // Later ?, not saved at the moment
QTHchanged(); 
Locatorchanged();
Frequencychanged();
HisRSTchanged();
MyRSTchanged();
Datechanged();
Timechanged();

QFile f(settings.QSOFileName);
f.open(IO_WriteOnly | IO_Append);
QTextStream stream(&f);
stream << "<CALL:" << RemoteCallsign->text().length() <<">" << RemoteCallsign->text() ;
if (settings.callsign != "")
 stream << "<OPERATOR:" <<settings.callsign.length() << ">" <<settings.callsign;
if (Qth->text() != "")
 stream << "<QTH:" << Qth->text().length() << ">" << Qth->text();
if (Loc->text() != "")
 stream << "<GRIDSQUARE:" << Loc->text().length() << ">" << Loc->text(); 
if (QsoFrequency->text() != "")
 stream << "<BAND:" << QsoFrequency->text().length() << ">" << QsoFrequency->text();
if (QsoDate->text() != "")
 stream << "<QSO_DATE:8:d>" << QDateTime::currentDateTime().toString("yyyyMMdd");
if (QsoTime->text() !="" )
 stream << "<TIME_ON:" << QsoTime->text().length() << ">" << QsoTime->text();
if ( HisRST->text() != "" )
 stream << "<RST_SENT:" << HisRST->text().length() << ">" << HisRST->text();    
if ( MyRST->text() != "" )
 stream << "<RST_RCVD:" << MyRST->text().length() << ">" << MyRST->text(); 
if (settings.ActChannel != 0 )
{
 stream << "<MODE:";
 switch(settings.ActChannel->getModulationType() )
 {
  case QPSK:
  case BPSK:
    stream << "5>PSK31";     
   break;

  case RTTY:
   stream <<"4>RTTY";
   break;
         
  case MFSK16:
   stream <<"6:MFSK16";
   break;
         
  default:
   stream <<"5>PSK31";
        }    
}
stream << "<eor>\n";
f.close();
clear(); 
}
void QSOData::destroy()
{
 if(QsoData)
  delete QsoData;
 QsoData=0;
}
