/* -------------------------------------------------------------------- *
 * slave_pvm.c                                                          *
 *                                                                      *
 * This is the slave program for the simple PVM demonstration           *
 * -------------------------------------------------------------------- */
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <pvm3.h>
        
#define MSG_LEN     20
void convert_to_upper(char*);
        
int main()
{
    int mytid;
    int parent_tid;
    char message[MSG_LEN];
        
    /* enroll ourselves into the PVM system         */
    mytid = pvm_mytid();
        
    /* get the task ID of the master                */
    parent_tid = pvm_parent();
        
   	/* receive the original string from master      */
    pvm_recv(parent_tid, 0);
    pvm_upkstr(message);

    /* convert the string to upper case             */
    convert_to_upper(message);
     
    /* send the converted string to the master      */
    pvm_initsend(PvmDataDefault);
        
    pvm_pkstr(message);
    pvm_send(parent_tid, 0);
        
    /* clean up and exit from the PVM system        */
    pvm_exit();
 
    exit(EXIT_SUCCESS);
} /* end main() */
        
/* function to convert the given string into upper case */
void convert_to_upper(char* str)
{
    while(*str != '\0')
    {
        *str = toupper(*str);
        str++;
    }
} /* end convert_to_upper() */
        
/* end slave_pvm.c */
        
