/***************************************************************************
                          gttextwidget.h  -  description
                             -------------------
    begin                : Don Sep 14 18:17:08 CEST 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GTTEXTWIDGET_H
#define GTTEXTWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <qregexp.h>
#include <qstring.h>
#include <qcolor.h>
#include <qgridview.h>
#include <qdragobject.h>
#include <qscrollbar.h>
#include <qfont.h>
#include <qwidget.h>
#include <qptrlist.h>
#include <qpainter.h>

#define MARKDIR_TOPDOWN 1
#define MARKDIR_DOWNTOP 2
#define MARKTIMER 300

/**
 * In this structure we hold an entire line for the GTTextWidget.
 * GTTextWidget use a QPtrList for all its lines
 */

class GTTextLine {
	public:
		GTTextLine (bool color) { c = color; s = "";m = false; }
		QString text() { return s; }
		bool color() { return c; }
		bool marked() { return m; }
		void setText (QString text) { s = text; }
		void setMarked (bool mark) { m = mark; }
	private:
		bool c;
		QString s;
		bool m;
};

class GTTextWidget : public QGridView
{
  Q_OBJECT 
public:
    GTTextWidget(QWidget* parent, int l=1000);
    ~GTTextWidget();
  /** Appends an Char to the text with color col */
  void appendChar (char c, bool col, bool rep=true);
  void appendString (char* text, bool signal=true, bool col=false);
  void setFont (QFont f);
  void contentsMouseMoveEvent (QMouseEvent* e);
  void setEditEnabled (bool ed);
  void appendString (QString text, bool signal=true);
  void setColors (QColor col1, QColor col2);
  void setCallCheckEnabled (bool s);
  void clear();
private: // Private methods
  /** This draws an Line to the widget */
  void paintCell (QPainter* p, int row, int);
  void newLine();
  void resizeEvent (QResizeEvent* e);
  void clearAllMarks();
  void contentsMousePressEvent( QMouseEvent *e);
  void contentsMouseReleaseEvent (QMouseEvent* e);
  void focusInEvent( QFocusEvent * );
  void focusOutEvent ( QFocusEvent * );
  void keyPressEvent( QKeyEvent *e );
  void dragEnterEvent(QDragEnterEvent* event) ;
  void dropEvent(QDropEvent* event);
  QString getMarkedText();
	QScrollBar* vscroll;
  /** Makes the Call check, but only if we use the 'transmit' Color. This is an Digimode specific functions, normal programs should'nt use it */
  void doCallCheck();
	QPtrList<GTTextLine> line;
	unsigned int maxlines;
	QFont font;
	bool currentcol;
	QColor textcolor[2];
  int firstline,lastline;
  int markdirection;
  int lastmarkline;
	int mark_new;
	int marking;
	QTimer* scrolltimer;
	QTimer* blinktimer;
	bool cursoron;
	bool edited;
	bool callCheckEnabled;
private slots:
  void slotTimerOben();
  void slotTimerUnten();
  void slotCursorBlink();
  void slotKey (char k);
signals:
	void keyPressed (char k);
	void textAppended (char* text);
	void newCallsign (QString callsign);
public slots: // Public slots
  void slotPageUp();
	void slotPageDown();
};

#endif
