/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include <stdlib.h>
#include "../log.h"
#include "../ballistics.h"
#include "../terrain.h"
#include "../aiexterns.h"
#include "basic.h"

Shellstat_bal
wepBasicInit(struct Projectilepos_bal *prjpos, void **guide,
	     Shellstat_bal(*initexplosion) (struct Projectilepos_bal *
					    prjpos, void **explosioninfo),
	     void **explosioninfo)
{
    Player_pl *plhit = NULL;
    int ix, iy;
/*    Shellstat_bal res;

    res = balEnvironmentAdjustProjPos(prjpos);*/
    *guide = NULL;

    if(balCheckIntersect
       (prjpos->ox, prjpos->oy, prjpos->x, prjpos->y, &plhit, &ix, &iy))
    {
	prjpos->x = ix;
	prjpos->y = iy;
	aihExplosionHook(prjpos);
	aihExplosionHook(prjpos);
	return initexplosion(prjpos, explosioninfo);
    }
    else
    {
	prjpos->rox = prjpos->ox = prjpos->x;
	prjpos->roy = prjpos->oy = prjpos->y;
	return FLYING;
    }
}

Shellstat_bal
wepBasicGuidance(void *info, struct Projectilepos_bal * prjpos,
		 Shellstat_bal(*initexplosion) (struct Projectilepos_bal *
						prjpos,
						void **explosioninfo),
		 void **explosioninfo)
{
    Shellstat_bal res;
    Player_pl *plhit = NULL;
    int ix, iy;

    prjpos->rox = prjpos->ox = prjpos->x;
    prjpos->roy = prjpos->oy = prjpos->y;
    prjpos->x += prjpos->vx;
    prjpos->y += prjpos->vy;
    prjpos->vy -= bal_grav / bal_lerp_tweak;
    logPrintf(SPAM, "bal_grav=%lf bal_lerp_tweak=%lf bal_wind=%i\n",
	      bal_grav, bal_lerp_tweak, bal_wind);
    logPrintf(SPAM,
	      "\nprjpos: {id = %d, rox = %lf, roy = %lf, ox = %lf, oy = %lf, x = %lf, y = %lf, vx = %lf, vy = %lf}\n",
	      prjpos->id, prjpos->rox, prjpos->roy, prjpos->ox, prjpos->oy,
	      prjpos->x, prjpos->y, prjpos->vx, prjpos->vy);

    if((res = balEnvironmentAdjustProjPos(prjpos)) != FLYING
       || balCheckIntersect(prjpos->ox, prjpos->oy, prjpos->x, prjpos->y,
			    &plhit, &ix, &iy))
    {
	if(plLookupPlayer(prjpos->id))
	{
	    logPrintf(SPAM, "Intersection at (%i, %i) of %s's shot\n", ix,
		      iy, plLookupPlayer(prjpos->id)->name);
	}
	else
	{
	    logPrintf(SPAM, "Intersection at (%i, %i) of null's shot\n", ix,
		      iy);
	}
	if(plhit != NULL)
	    logPrintf(SPAM, "and hit %s\n", plhit->name);
	switch (res)
	{
	    case HOLDING:
		/* wtf ??? */
		break;
	    case FLYING:
		prjpos->x = ix;
		prjpos->y = iy;
		/* fall through */
	    case EXPLODING:
		return initexplosion(prjpos, explosioninfo);
		break;
	    case FREEING:
		return FREEING;
		break;
	}
    }

    return FLYING;
}

Shellstat_bal
wepBasicExplosionInit(struct Projectilepos_bal * prjpos, void **explosioninfo)
{
    struct SimpleExplosion_wep *e =
	(struct SimpleExplosion_wep *)
	malloc(sizeof(struct SimpleExplosion_wep));

    e->x = prjpos->x;
    e->y = prjpos->y;
    e->r = 0;
    e->dx = 5;
    e->id = prjpos->id;
    e->max_radius = 50;
    e->wid = prjpos->wid;

    *((struct SimpleExplosion_wep **) explosioninfo) = e;
    return EXPLODING;
}
