/***************************************************************************
                          iplook.cpp  -  description
                             -------------------
    begin                : Tue Apr 25 2000
    copyright            : (C) 2000 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <arpa/inet.h>

#include <kdebug.h>

#include "iplook.h"
#include "myktreelistitem.h"


IPLook::IPLook (QObject * parent, MyHostItem * hostitem):QObject (parent),
host (hostitem)
{
}

IPLook::~IPLook ()
{
}

/** Liest den Masterbrowser ein */
void
IPLook::getIP ()
{
  proc = new KProcess ();
  if (!proc)
    {
      kdError (7199) << "IPLook::Can not create a process." << endl;
      return;
    }
  (*proc) << "nmblookup" << host->Name () << "-S";
  QString ip;
  host->getIP (&ip);
  if (host->getNetIP ())
    (*proc) << "-U" << ip;
  connect (proc, SIGNAL (processExited (KProcess *)), this,
	   SLOT (onProcExit (KProcess *)));
  connect (proc, SIGNAL (receivedStdout (KProcess *, char *, int)), this,
	   SLOT (IPLookStdout (KProcess *, char *, int)));
  proc->start (KProcess::NotifyOnExit, KProcess::Stdout);
  return;
}

void
IPLook::IPLookStdout (KProcess *, char *buffer, int n)
{
  out.append (QString::fromLocal8Bit (buffer, n));
}

/** Wird aufgerufen wenn der Process sich beendet */
void
IPLook::onProcExit (KProcess * killedproc)
{
  QString s = out;
  int i;
  u_long ip = 0;
  i = s.find ((QString) host->Name () + "<00>");	// <00> means ->Workstation
  // Find the IP
  if (i > 0)
    {
      s.truncate (i);
      i = s.findRev ("\n");
      if (i > 0)
	{
	  s = s.right (s.length () - i - 1);
	  ip = htonl (inet_addr ((const char *) s.stripWhiteSpace ()));
	  if (ip
	      && ((out.contains (host->getWorkgroupName ()))
		  || (out.contains ("No status response"))))
	    host->setNetIP (ip);
	}
    }
  //////////////////////////////////////
  // find NetbiosNames
  host->clearNetNames ();
  s = out;
  QString name;
  QString service;
  QString type;
  QString group;
  i = s.find ("<ACTIVE>");
  i = s.findRev ("\n", i);
  s = nextline (out, i);	// s = "received n names
  s = nextline (out, i);	// s = first line with netbiosname
  while ((i != -1) && (!(s.contains ("<ACTIVE>") == 0)))
    {				//all lines which have active name
      name = s.mid (1, 16);
      // strip whitepace on right site
      while ((name.right (1) == " ") && (name.length () > 0))
	name.remove ((uint) name.length () - 1, 1);
      service = s.mid (18, 2);
      type = s.mid (32, 1);
      (s.contains ("<GROUP>") > 0) ? group = "<GROUP>" : group =
	QString::null;
      host->appendNetName (name, service, type, group);
      s = nextline (out, i);
    }
  if (killedproc == proc)
    {
      delete proc;
      proc = 0;
    }
  else
    kdWarning (7199) << "IPLook: Mmmhhh... not my process" << endl;
  emit isExited (this);
}

/** Gibt Zeile ab index bis Ende der Zeile ('\n')
zurck, index ist danach auf Anfang der nchsten Zeile; */
QString IPLook::nextline (QString & in, int &index)
{
  int
    i;
  if (index != -1)
    {
      i = index;
      index = in.find ("\n", index);
      if (index != -1)
	{
	  index++;
	  return in.mid (i, index - i - 1);
	}
      else
	{
	  return in.right (i);
	}
    }
  return "";
}
