h27550
s 00004/00003/00232
d D 1.40 00/08/26 19:52:51 nitehawk 41 40
c convert all logging calls into logmsg
cC
cK53948
e
s 00003/00007/00232
d D 1.39 00/08/22 20:17:50 nitehawk 40 39
c Converting to new logmsg
cC
cHlocalhost.1ststep.net
cK51964
cZ-07:00
e
s 00000/00001/00239
d D 1.38 00/03/07 18:12:16 nitehawk 39 38
c Remove include of db.h
cC
cK58230
e
s 00000/00000/00240
d D 1.37 00/03/07 11:48:11 nitehawk 38 37
c Turn on SCCS flag
cC
cK08470
cX0xa1
e
s 00000/00003/00240
d D 1.36 00/03/06 22:38:34 nitehawk 37 36
c DB is already initialized before calling rundaemon
cK59463
e
s 00003/00000/00240
d D 1.35 00/02/29 00:50:39 nitehawk 36 35
c Log nodeid as part of startup process
cC
cK00381
e
s 00001/00001/00239
d D 1.34 00/02/26 23:03:19 nitehawk 35 34
c uplinksendmessage needs messageid parameter
cC
cK57314
e
s 00001/00001/00239
d D 1.33 00/02/20 19:59:50 nitehawk 34 33
c Additional parameter to dbfsmount
cC
cK57190
e
s 00000/00001/00240
d D 1.32 00/02/20 09:43:28 nitehawk 33 32
c Remove zone.h include
cK56415
e
s 00004/00011/00237
d D 1.31 00/02/17 14:08:42 nitehawk 32 31
c Added call to mount root database
c Removed loadzonedb function
cC
cK57894
e
s 00018/00051/00230
d D 1.30 00/02/15 12:37:23 nitehawk 31 30
c Loop consolidation:  All secondary loops consolidated into a
c single pass.  Main game loop now comprised of two secondary
c loops, one to load sockets into fdsets, another to process input
c post select.
cC
cK17742
e
s 00000/00000/00281
d D 1.29 00/02/10 08:40:48 nitehawk 30 29
c Rename: src/zone.c -> src/zone/zone.c
cC
cK26911
cPsrc/zone/zone.c
e
s 00003/00000/00278
d D 1.28 00/02/08 10:41:16 nitehawk 29 28
c Add call to netstartup
cC
cK04726
e
s 00009/00001/00269
d D 1.27 00/02/08 00:51:46 nitehawk 28 27
c Daemon function name setup for split binaries
c Added daemoninitstate to setup state variables according to daemon type
cK01290
e
s 00002/00002/00268
d D 1.26 00/02/05 20:03:48 nitehawk 27 26
c All daemons use the same ticklength and reporting cycle variables
cC
cK53952
e
s 00014/00012/00256
d D 1.25 00/02/05 18:12:14 nitehawk 26 25
c Loop throttling added - don't report on status every cycle
cK52022
e
s 00027/00007/00241
d D 1.24 00/02/05 13:50:52 nitehawk 25 24
c Uplink messages are now received via input buffers
cC
cK55349
e
s 00034/00025/00214
d D 1.23 00/02/04 20:11:42 nitehawk 24 23
c Added support for live reboots
cC
cK15364
e
s 00001/00004/00238
d D 1.22 00/02/04 10:27:40 nitehawk 23 22
c confcreatelisten expects list pointer instead of descriptor
cC
cK64292
e
s 00005/00000/00237
d D 1.21 00/02/01 20:55:24 nitehawk 22 21
c Check for interrupted syscall in primary select
cC
cK04311
e
s 00001/00001/00236
d D 1.20 00/02/01 12:25:32 nitehawk 21 20
c Pass message data struct to uplinksendmessage
cC
cK63571
e
s 00025/00002/00212
d D 1.19 00/02/01 11:28:48 nitehawk 20 19
c Added handling for daemon shutdown
cK63111
e
s 00022/00000/00192
d D 1.18 00/02/01 11:22:18 nitehawk 19 18
c Added loop to close sockets marked as STATUS_CLOSE
cK19904
e
s 00003/00003/00189
d D 1.17 00/01/30 13:27:50 nitehawk 18 17
c Updated to use new zone data pointer union
cC
cK44915
e
s 00007/00005/00185
d D 1.16 00/01/29 23:47:25 nitehawk 17 16
c Add call to uplinkreceivemessage when an uplink is marked for read
cC
cK47372
e
s 00001/00001/00189
d D 1.15 00/01/23 20:48:12 nitehawk 16 15
c Converting descriptor memory allocation to use new functions
cC
cK40810
e
s 00009/00006/00181
d D 1.14 00/01/21 19:46:37 nitehawk 15 14
c Zone daemon creates uplink according to configuration file
c Failure to create uplink causes listen socket to be created
cC
cK42936
e
s 00006/00000/00181
d D 1.13 00/01/20 21:37:11 nitehawk 14 13
c Added call to protocol negotiation
cC
cK39209
e
s 00004/00015/00177
d D 1.12 00/01/17 23:39:32 nitehawk 13 12
c Remove reference to uplink options in koptions
cC
cK27942
e
s 00002/00000/00190
d D 1.11 00/01/13 19:03:13 nitehawk 12 11
c Fixed small bug in descriptor tracking
cC
cK48272
e
s 00107/00012/00083
d D 1.10 00/01/13 18:58:28 nitehawk 11 10
c Main zone daemon loop finished
cK42050
e
s 00020/00012/00075
d D 1.9 00/01/13 16:35:05 nitehawk 10 9
c New variables added for conversion to new zone daemon loop
cK61576
e
s 00002/00002/00085
d D 1.8 00/01/11 12:27:33 nitehawk 9 8
c Converted RCS tags to SCCS tags
cC
cK51312
e
s 00002/00005/00085
d D 1.7 00/01/09 17:59:46 nitehawk 8 7
c Remove pointer assignements for next and prev
cC
cK57111
e
s 00002/00001/00088
d D 1.6 00/01/01 16:56:51 nitehawk 7 6
c Change netlisten call to confcreatelisten -
c Use XML config file to open listen socket
cC
cK04963
e
s 00003/00002/00086
d D 1.5 00/01/01 12:58:36 nitehawk 6 5
c Change calls to uplink and listen to use port and address
cK04636
cZ-08:00
e
s 00004/00035/00084
d D 1.4 99/12/21 00:03:38 nitehawk 5 4
c Pruned out all non-zone daemon code
cC
cK63205
e
s 00089/00004/00030
d D 1.3 99/12/20 23:28:45 nitehawk 4 3
c Change zonedloop to zonedaemon and copy in full rundaemon code.
cK62822
e
s 00018/00000/00016
d D 1.2 99/12/15 01:44:19 nitehawk 3 2
c Skeleton functions added: loadzonedb, zonedloop
cC
cK14230
e
s 00016/00000/00000
d D 1.1 99/12/14 23:59:27 nitehawk 2 1
cC
cF1
cK33270
cO-rw-rw-r--
e
s 00000/00000/00000
d D 1.0 99/12/14 23:59:27 nitehawk 1 0
c BitKeeper file /home/nitehawk/src/koalamud/src/zone.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK53183
cPsrc/zone.c
cR229cb595742dcbec
cV3
cZ+00:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
D 9
/* $Id: zone.c,v 1.1 1999/12/08 04:47:49 nitehawk Exp $ */
E 9
I 9
/* %Z% %M% %I% %Z% */
E 9
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: DAEMON
\***************************************************************/

D 9
#define _KOALAMUD_ZONE_C "$Id: zone.c,v 1.1 1999/12/08 04:47:49 nitehawk Exp $"
E 9
I 9
#define _KOALAMUD_ZONE_C "%Z% %K% %Z%"
E 9

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
D 33
#include "zone.h"
E 33
I 3
#include "network.h"
I 4
#include "log.h"
I 7
#include "conf.h"
I 10
#include "memory.h"
#include "llist.h"
I 14
#include "uplinkprotocol.h"
I 24
#include "reboot.h"
I 25
#include "buffer.h"
E 25
E 24
E 14
E 10
E 7
E 4
D 32

/* loadzonedb - Load the zone database from disk */
/* This function actually only loads the minimum zone data from disk - 
 *		indexes, common rooms, common mobiles, and common objects.
 * All other zone data is kept on disk until certain thresholds are
 * breached (closeness to the room, mobile activity, etc)
 */
D 4
koalaerror loadzonedb(koalaoptions *koptions)
E 4
I 4
koalaerror loadzonedb(void)
E 4
{
		return KESUCCESS;
}
E 32
I 32
D 39
#include "db.h"
E 39
E 32

I 28
/* Initialize state variables */
koalaerror daemoninitstate(void)
{
	koptions.daemontype = DAEMON_ZONE;
	return KESUCCESS;
};

/* Startup the daemon */
E 28
D 4
/* zonedloop - Run the loop for the zone server */
koalaerror zonedloop(koalaoptions *koptions)
E 4
I 4
/* zonedaemon - Handle daemon functions for a zone server */
D 28
koalaerror zonedaemon(void)
E 28
I 28
koalaerror rundaemon(void)
E 28
E 4
{
D 4
		return KESUCCESS;
E 4
I 4
D 20
	bool running = TRUE;
E 20
D 8
	descriptor masterlisten = {NULL, NULL, 0, 0, {NULL}};
	descriptor uplinkconnection = {NULL, NULL, 0, 0, {NULL}};
E 8
I 8
D 10
	descriptor masterlisten = {0, 0, {NULL}};
	descriptor uplinkconnection = {0, 0, {NULL}};
E 8
	pdescriptor client = NULL;
	char welcome[] = "Welcome to KoalaMud.  This is early development"
		" code.  Please check back later.\n\r";
E 10
I 10
	pdescriptor desc = NULL;
	pdescriptor newdesc = NULL;
E 10
	koalaerror acceptreturn;
I 10
	listnodeptr desclist, tmplist;
	fd_set insockets, outsockets, errsockets;
D 40
	char logbuf[MAXLOGLINELEN];
E 40
	int descriptorcount;
	int numuplinks;
	int maxdescriptor;
I 11
D 26
	struct timeval nowait = {0, 0};
E 26
	struct timeval sleeper;
	int selectreturn;
I 26
	unsigned long loopcount = 0;
I 29
	
	/* Startup networking */
	netstartup();
I 32

D 37
	/* Mount root database */
D 34
	dbfsmount(koptions.dbrootpath, NULL);
E 34
I 34
	dbfsmount(koptions.dbrootpath, NULL, MF_NORMAL);
E 34
E 32
E 29
E 26
E 11

E 37
I 11
	/* Get pointer to master descriptor list */
E 11
	desclist = getdescriptorlist();
D 15
	newdesc = (pdescriptor)malloc(sizeof(descriptor));
	listaddnode(desclist, newdesc);
E 15
E 10
D 8

D 5
	if (netstartup() != KESUCCESS)
	{
		logerr("Error starting network, shutting down");
		return KENONETWORK;
	}

E 5
	masterlisten.next = masterlisten.prev = &masterlisten;
	uplinkconnection.next = uplinkconnection.prev = &uplinkconnection;
E 8

D 5
	/* Create uplink connection if server type is client */
	if (koptions.daemontype == DAEMON_CLIENT)
	{
		if (netuplink(&uplinkconnection) < 0)
		{
			logerr("Error starting network interface, shutting down");
			return KENONETWORK;
		}
		masterlisten.next = masterlisten.prev = &masterlisten;
		uplinkconnection.next = uplinkconnection.prev = &masterlisten;
	}

E 5
D 24
	/* If we are setting up a zone server, we should connect to a hub
	 * server if the uplink is defined, otherwise, start listening on the
	 * uplink port */
D 5
	if (koptions.daemontype == DAEMON_ZONE)
E 5
I 5
D 13
	if (koptions.uplinkopts.uplinkopt)
E 13
I 13
D 15
	/*FIXME*/
	if (confcreatelisten(newdesc) < 0)
E 15
I 15
	if (confcreateuplink(desclist) == KENOUPLINK)
E 24
I 24
	/* check to see if this was a reboot */
	if (!(kstate.running == DSTATE_REBOOTING &&
				(reloaddescriptors() == KESUCCESS)))
E 24
E 15
E 13
E 5
	{
D 5
		if (koptions.uplinkopts.uplinkopt)
		{
			if (netuplink(&uplinkconnection) < 0)
			{
				logerr("Error starting network interface, shutting down");
				return KENONETWORK;
			}
		}
		else
E 5
I 5
D 6
		if (netuplink(&uplinkconnection) < 0)
E 6
I 6
D 10
		if (netuplink(&uplinkconnection, koptions.uplinkopts.uplinkhost,
E 10
I 10
D 13
		if (netuplink(newdesc, koptions.uplinkopts.uplinkhost,
E 10
					koptions.uplinkopts.uplinkport) < 0)
E 6
E 5
		{
D 5
			if (netlisten(&masterlisten, koptions.port) < 0)
			{
				logerr("Error starting network interface, shutting down");
				return KENONETWORK;
			}
E 5
I 5
			logerr("Error starting network interface, shutting down");
			return KENONETWORK;
E 5
		}
	}
	else
	{
D 5
		/* we are starting either a hub server or a client server,
		 * either way, we need a listen socket */
E 5
D 6
		if (netlisten(&masterlisten, koptions.port) < 0)
E 6
I 6
D 7
		if (netlisten(&masterlisten, NULL, koptions.port) < 0)
E 7
I 7
D 10
		if (confcreatelisten(&masterlisten) < 0)
E 10
I 10
		if (confcreatelisten(newdesc) < 0)
E 10
E 7
E 6
		{
			logerr("Error starting network interface, shutting down");
			return KENONETWORK;
		}
E 13
I 13
D 15
		logerr("Error starting network interface, shutting down");
		return KENONETWORK;
E 15
I 15
D 16
		newdesc = (pdescriptor)malloc(sizeof(descriptor));
E 16
I 16
D 23
		newdesc = allocdescriptor();
E 16
		listaddnode(desclist, newdesc);

		if (confcreatelisten(newdesc) < 0)
E 23
I 23
D 24
		if (confcreatelisten(desclist) < 0)
E 24
I 24
		/* If we are setting up a zone server, we should connect to a hub
		 * server if the uplink is defined, otherwise, start listening on the
		 * uplink port */
		if (confcreateuplink(desclist) == KENOUPLINK)
E 24
E 23
		{
D 24
			logerr("Error starting network interface, shutting down");
			return KENONETWORK;
E 24
I 24
			if (confcreatelisten(desclist) < 0)
			{
D 41
				logerr("Error starting network interface, shutting down");
E 41
I 41
				logmsg(LOGCRIT, "Error starting network interface,"
						" shutting down");
E 41
				return KENONETWORK;
			}
E 24
		}
E 15
E 13
	}

I 36
D 40
	sprintf(logbuf, "Starting main zone daemon loop on node ID: %x",
E 40
I 40
	logmsg(LOGINFO, "Starting main zone daemon loop on node ID: %x",
E 40
			kstate.nodeid);
D 40
	logmsg(logbuf);
E 40
E 36
D 20
	while (running)
E 20
I 20
D 24
	while (kstate.running)
E 24
I 24
	while (kstate.running == DSTATE_RUNNING)
E 24
E 20
	{
D 10
		acceptreturn = netaccept(&masterlisten, &client);
E 10
I 10
D 11
		acceptreturn = netaccept(newdesc, &desc);
E 10
		if (acceptreturn == KENOMEM)
E 11
I 11
		/* Zero out counters and socket sets */
		descriptorcount = 0;
		numuplinks = 0;
		maxdescriptor = 0;
		FD_ZERO(&insockets);
		FD_ZERO(&outsockets);
		FD_ZERO(&errsockets);

		/* Fill in fd_sets with open sockets */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
D 18
			desc = (pdescriptor)tmplist->data;
E 18
I 18
			desc = tmplist->data.desc;
E 18

			/* Filter dummy sockets */
			if (desc->type == DESCRIPTOR_DUMMY)
			{
				continue;
			}

			/* Add Descriptor to select sets */
			if (desc->type != DESCRIPTOR_LISTEN)
			{
				numuplinks++;
				FD_SET(desc->socket, &errsockets);
				FD_SET(desc->socket, &outsockets);
			}
			FD_SET(desc->socket, &insockets);
			descriptorcount++;

			maxdescriptor = (maxdescriptor > desc->socket) ?
				maxdescriptor : desc->socket;
		}

D 26
		snprintf(logbuf, MAXLOGLINELEN,
				"%d descriptors, %d Listen, %d Uplink, Max FD=%d",
				descriptorcount, (descriptorcount - numuplinks), (numuplinks),
				maxdescriptor);
		logdbg(logbuf);
E 26
I 26
D 27
		if (((loopcount++) % ZONEREPORTPERIOD) == 0)
E 27
I 27
		if (((loopcount++) % koptions.reportingperiod) == 0)
E 27
		{
D 40
			snprintf(logbuf, MAXLOGLINELEN,
					"%d descriptors, %d Listen, %d Uplink, Max FD=%d",
E 40
I 40
			logmsg(LOGINFO, "%d descriptors, %d Listen, %d Uplink, Max FD=%d",
E 40
					descriptorcount, (descriptorcount - numuplinks),
					(numuplinks),
					maxdescriptor);
D 40
			logdbg(logbuf);
E 40
		}

		sleeper.tv_sec = 0;
D 27
		sleeper.tv_usec = MAXZONETICKLEN;
E 27
I 27
		sleeper.tv_usec = koptions.ticklen;
E 27
E 26

		if ((selectreturn = select(maxdescriptor +1, &insockets,
D 26
			NULL, &errsockets, &nowait)) < 0)
E 26
I 26
			NULL, &errsockets, &sleeper)) < 0)
E 26
E 11
		{
I 22
			if (errno == EINTR)
			{
D 40
				logmsg("Waking up to process signal");
E 40
I 40
				logmsg(LOGINFO, "Waking up to process signal");
E 40
				continue;
			}
E 22
D 10
			close(masterlisten.socket);
E 10
D 11
			return KENOMEM;
E 11
I 11
D 41
			logerr("Main zone daemon loop dead, bailing water");
E 41
I 41
			logmsg(LOGCRIT, "Main zone daemon loop dead, bailing water");
E 41
			return KESELECTFAIL;
E 11
		}
I 19
D 31

		/* Close descriptors marked to be closed */
E 31
I 31
		
		/* Process data from select */
E 31
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
			desc = tmplist->data.desc;

D 31
			/* Filter out dummy descriptors */
			if (desc->type == DESCRIPTOR_DUMMY)
E 31
I 31
			/* Filter out invalid descriptors
			 * Since this is a zone daemon, player descriptors are considered
			 * invalid
			 */
			if (desc->type == DESCRIPTOR_DUMMY
					|| desc->type == DESCRIPTOR_NULL
					|| desc->type == DESCRIPTOR_PLAYER)
E 31
			{
				continue;
			}

D 31
			/* Is this descriptor marked for closure */
			if (desc->status == STATUS_CLOSE)
E 31
I 31
			/* Close descriptors */
			if (desc->status == STATUS_CLOSE
					|| FD_ISSET(desc->socket, &errsockets))
E 31
			{
				tmplist = listprevnode(tmplist);
				listremovenode(desclist, desc);
				FD_CLR(desc->socket, &insockets);
				FD_CLR(desc->socket, &outsockets);
				netclose(desc);
			}
D 31
		}
E 19
D 11
		if (acceptreturn == KENOACCEPT)
E 11
I 11
				
		/* Handle sockets in the error state */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
E 11
		{
D 11
			/* Probaly just no connections waiting
			 * 	shouldn't get this in normal operations */
			logdbg("No connections waiting");
			continue;
E 11
I 11
D 18
			desc = (pdescriptor)tmplist->data;
E 18
I 18
			desc = tmplist->data.desc;
E 18

			/* Filter dummy sockets */
			if (desc->type == DESCRIPTOR_DUMMY)
			{
				continue;
			}
			
			/* If this descriptor has an error on it */
			if (FD_ISSET(desc->socket, &errsockets))
			{
				FD_CLR(desc->socket, &insockets);
				FD_CLR(desc->socket, &outsockets);
I 12
				tmplist = listprevnode(tmplist);
E 12
				listremovenode(desclist, desc);
				netclose(desc);
			}
E 11
		}
E 31

D 10
		netwrite(client, COPYRIGHTSTR, strlen(COPYRIGHTSTR));
		netwrite(client, welcome, strlen(welcome));
E 10
I 10
D 11
		netwrite(desc, COPYRIGHTSTR, strlen(COPYRIGHTSTR));
		netwrite(desc, magic.daemonmagic, strlen(magic.daemonmagic));
E 11
I 11
D 31
		/* Handle new uplinks and incoming requests for zone data and actions */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
D 18
			desc = (pdescriptor)tmplist->data;
E 18
I 18
			desc = tmplist->data.desc;
E 18

			/* Filter dummy sockets */
			if (desc->type == DESCRIPTOR_DUMMY)
			{
				continue;
			}

			/* Is there data on the socket */
E 31
I 31
			/* Handle sockets on input set */
E 31
			if (FD_ISSET(desc->socket, &insockets))
			{
				if (desc->type == DESCRIPTOR_LISTEN)
				{
					acceptreturn = netaccept(desc, &newdesc);
					if (acceptreturn == KENOMEM)
					{
						return KENOMEM;
					}
					if (acceptreturn == KENOACCEPT)
					{
						/* Probaly just no connections waiting
			 			 * 	shouldn't get this in normal operations */
D 41
						logdbg("No connections waiting");
E 41
I 41
						logmsg(LOGWARN, "No connections waiting");
E 41
						continue;
					}

					netwrite(newdesc, magic.daemonmagic,
								strlen(magic.daemonmagic));
I 12
					listaddnode(desclist, newdesc);
E 12
D 31
				}
E 31
I 31
				}  // Is listen socket
E 31
I 17
D 25
				else if (desc->type == DESCRIPTOR_UNKNOWN &&
							desc->status < STATUS_NOMINAL)
				{
					uplinknegotiatestage(desc);
				}
				/* We must have data from our uplink */
E 25
E 17
				else
				{
I 14
D 17
					if (desc->type == DESCRIPTOR_UNKNOWN &&
							desc->status < STATUS_NOMINAL)
					{
						uplinknegotiatestage(desc);
					}
E 17
I 17
D 25
					uplinkreceivemessage(desc);
E 25
I 25
					buffer_receive(desc);
E 25
E 17
E 14
				}
I 25
D 31
			}
		}

		/* Loop through descriptors and parse input */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
			desc = tmplist->data.desc;
E 31
I 31
			} // Has input?
E 31

I 31
			/* Parse waiting input */
E 31
			if (desc->type == DESCRIPTOR_UNKNOWN &&
						desc->status < STATUS_NOMINAL)
			{
				/* This is an uplink, but we don't know what type yet
				 * - Handle protocol negotiation
				 */
				uplinknegotiatestage(desc);
			}
			/* We can't uplink to a client server */
			else if (desc->type >= DESCRIPTOR_HUBSRV &&
					desc->type <= DESCRIPTOR_ZONESRV &&
					desc->status == STATUS_NOMINAL)
			{
				/* If we have input on an uplink, pass it off to
				 * uplinkreceivemessage
				 */
				uplinkreceivemessage(desc);
E 25
			}
D 31
		}
E 11
E 10
D 26

D 10
		netclose(client);
E 10
I 10
D 11
		netclose(desc);
E 11
I 11
		/* Throttling Control - Use quarter second cycles */
		sleeper.tv_sec = 0;
		sleeper.tv_usec = 250000;
		select(0, NULL, NULL, NULL, &sleeper);
E 26
E 11
E 10
	}
E 31
I 31
		}  // Select processor loop
	}  // Main zone daemon loop
E 31
I 20

D 24
	/* If we get here, we were told to shutdown the system, scan through the
	 * descriptor list and send a disconnect message to all uplinks */
	for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
E 24
I 24
	if (kstate.running == DSTATE_SHUTDOWN)
E 24
	{
D 24
		message_data msgdata;
		msgdata.data = NULL;
E 24
I 24
		/* If we get here, we were told to shutdown the system, scan through the
		 * descriptor list and send a disconnect message to all uplinks */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
			message_data msgdata;
			msgdata.data = NULL;
E 24

D 24
		desc = tmplist->data.desc;
		
		switch (desc->type)
		{
			case DESCRIPTOR_HUBSRV:
			case DESCRIPTOR_CLIENTSRV:
			case DESCRIPTOR_ZONESRV:
				/* Its an uplink - send a disconnect message */
D 21
				uplinksendmessage(desc, 0, MSGTYPE_DISCONNECT, NULL);
E 21
I 21
				uplinksendmessage(desc, 0, MSGTYPE_DISCONNECT, &msgdata);
E 21
				break;
E 24
I 24
			desc = tmplist->data.desc;
			
			switch (desc->type)
			{
				case DESCRIPTOR_HUBSRV:
				case DESCRIPTOR_CLIENTSRV:
				case DESCRIPTOR_ZONESRV:
					/* Its an uplink - send a disconnect message */
D 35
					uplinksendmessage(desc, 0, MSGTYPE_DISCONNECT, &msgdata);
E 35
I 35
					uplinksendmessage(desc, 0, MSGTYPE_DISCONNECT, &msgdata, 0);
E 35
					break;
E 24

D 24
			default:
				continue;
E 24
I 24
				default:
					continue;
			}
E 24
		}
	}

E 20
D 11
	
E 11
	return KESUCCESS;
E 4
}
E 3
E 2
I 1
E 1
