/* @(#) dbkoala.c 1.3 @(#) */
/***************************************************************\
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: VM
\***************************************************************/

#define _KOALAMUD_DBKOALA_C "@(#) nitehawk@localhost.1ststep.net|lib/vm/dbkoala.c|20000823031749|15261 @(#)"

#include "autoconf.h"
#include <sys/stat.h>

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "conf.h"

#include "module.h"
#include "vm.h"
#include "vminternal.h"

/* This file implements the raw koala backend.  The API in this
 * file should *NOT* be called from outside of the VM library.
 */

/* Global variables */

/* Module state */
module_t dbkoalamodule =
{
	"DB Koala",
	"@(#) dbkoala.c 1.3 @(#)",
	MODSTATE_UNDEFINED,
	dbkoalastartup,
	dbkoalalinkup,
	dbkoalashutdown
};

/********************************
 * State Control				*
 *******************************/
/* Speed is not critical for the state control functions, as they are only
 * going to be called during startup and shutdown. */
/* dbstartup - Startup db driver.  This should do things like prepare the
 * variables that connect us to an external SQL server.
 */
int dbkoalastartup(void)
{
	/* Must either be undefined - meaning we have not done a startup this run,
	 * or stopped, meaning we are restarting during the same binary run */
	if (!(dbkoalamodule.state == MODSTATE_UNDEFINED ||
			dbkoalamodule.state == MODSTATE_STOPPED))
		return VMBADSTATE;
	/* Reflect that we are starting up */
	dbkoalamodule.state = MODSTATE_STARTUPINPROGRESS;

	/* Log a startup message */
	logmsg(LOGINFO, "Starting koala database driver");

	/* All done with startup */
	dbkoalamodule.state = MODSTATE_STARTED;

	/* Everything Happy :) */
	return VMSUCCESS;
}

/* vmlinkup - Create connection to external database or load disk indexes and
 * hashtables
 */
int dbkoalalinkup(void)
{
	/* If the current state is not 'STARTED', then we are not prepared to do
	 * the linkup */
	if (dbkoalamodule.state != MODSTATE_STARTED)
		return VMBADSTATE;
	/* show that we are doing linkup */
	dbkoalamodule.state = MODSTATE_LINKUPINPROGRESS;

	/* Linkup complete */
	dbkoalamodule.state = MODSTATE_LINKED;

	/* Everything Happy :) */
	return VMSUCCESS;
}

/* dbshutdown - close off the database and clean up any external connections
 */
int dbkoalashutdown(void)
{
	/* Can't shutdown unless we are currently 'linked' */
	if (dbkoalamodule.state != MODSTATE_LINKED)
		return VMBADSTATE;
	/* show that we are doing shutdown */
	dbkoalamodule.state = MODSTATE_SHUTDOWNINPROGRESS;

	/* shutdown complete */
	dbkoalamodule.state = MODSTATE_STOPPED;

	/* Everything Happy :) */
	return VMSUCCESS;
}
