h56982
s 00002/00002/00148
d D 1.6 00/08/22 20:17:49 nitehawk 7 6
c Converting to new logmsg
cC
cK28409
e
s 00002/00001/00148
d D 1.5 00/07/29 23:30:59 nitehawk 6 5
c Debugging message added
cC
cHlocalhost.1ststep.net
cK27205
cZ-07:00
e
s 00046/00000/00103
d D 1.4 00/03/19 22:27:07 nitehawk 5 4
c Setup to read mysql options from config.
c Start function to rebuild database tables
cC
cK24244
e
s 00005/00002/00098
d D 1.3 00/03/12 09:39:30 nitehawk 4 3
c Fix startup state check
cC
cK15815
e
s 00023/00015/00077
d D 1.2 00/03/12 08:29:35 nitehawk 3 2
c Convert to new module definition structure
cK10509
e
s 00092/00000/00000
d D 1.1 00/03/11 21:27:19 nitehawk 2 1
cF1
cK01912
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/03/11 21:27:19 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/lib/vm/dbmysql.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK49268
cPlib/vm/dbmysql.c
cRf0759401cec8cefd
cV3
cX0xa1
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: VM
\***************************************************************/

#define _KOALAMUD_DBMYSQL_C "%Z% %K% %Z%"

#include "autoconf.h"
#include <sys/stat.h>

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "conf.h"

#include "module.h"
#include "vm.h"
#include "vminternal.h"

/* This file implements the linkage between koala and mysql.  The API in this
 * file should *NOT* be called from outside of the VM library.
 */

/* Global variables */

D 3
/* Module state */
modstate_t dbmysqlmodstate = MODSTATE_UNDEFINED;
E 3
I 3
/* Module data */
module_t dbmysqlmodule =
{
	"DB Mysql",
	"%Z% %M% %I% %Z%",
	MODSTATE_UNDEFINED,
	dbmysqlstartup,
	dbmysqllinkup,
	dbmysqlshutdown
};
E 3

/********************************
 * State Control				*
 *******************************/
/* Speed is not critical for the state control functions, as they are only
 * going to be called during startup and shutdown. */
/* dbstartup - Startup db driver.  This should do things like prepare the
 * variables that connect us to an external SQL server.
 */
D 3
vmerr_t dbmysqlstartup(void)
E 3
I 3
int dbmysqlstartup(void)
E 3
{
	/* Must either be undefined - meaning we have not done a startup this run,
	 * or stopped, meaning we are restarting during the same binary run */
D 3
	if (dbmysqlmodstate != MODSTATE_UNDEFINED ||
			dbmysqlmodstate != MODSTATE_STOPPED)
E 3
I 3
D 4
	if (dbmysqlmodule.state != MODSTATE_UNDEFINED ||
			dbmysqlmodule.state != MODSTATE_STOPPED)
E 4
I 4
	if (!(dbmysqlmodule.state == MODSTATE_UNDEFINED ||
			dbmysqlmodule.state == MODSTATE_STOPPED))
E 4
E 3
		return VMBADSTATE;
	/* Reflect that we are starting up */
D 3
	dbmysqlmodstate = MODSTATE_STARTUPINPROGRESS;
E 3
I 3
	dbmysqlmodule.state = MODSTATE_STARTUPINPROGRESS;
I 4

	/* Log a message */
D 7
	logmsg("Starting mysql client driver");
E 7
I 7
	logmsg(LOGINFO, "Starting mysql client driver");
E 7
E 4
E 3

	/* All done with startup */
D 3
	dbmysqlmodstate = MODSTATE_STARTED;
E 3
I 3
	dbmysqlmodule.state = MODSTATE_STARTED;
E 3

	/* Everything Happy :) */
	return VMSUCCESS;
}

/* vmlinkup - Create connection to external database or load disk indexes and
 * hashtables
 */
D 3
vmerr_t dbmysqllinkup(void)
E 3
I 3
int dbmysqllinkup(void)
E 3
{
I 5
	char *mysqlhost = NULL;	// Will be null if connecting to localhost
	char *mysqluser = NULL;
	char *mysqlpass = NULL;
	char *mysqldb = NULL;
	bool enablemysql = FALSE;
	int mysqlport = 0;
	/* Casts in this definition are just to prevent compiler warnings */
	confoption_t copt[] =
	{
		{"ENABLE", OPT_BOOL, {(char**)&enablemysql}},
		{"HOST", OPT_STRING, {&mysqlhost}},
		{"USER", OPT_STRING, {&mysqluser}},
		{"PASSWORD", OPT_STRING, {&mysqlpass}},
		{"DATABASE", OPT_STRING, {&mysqldb}},
		{"PORT", OPT_UINT, {(char **)&mysqlport}},
	};
	int numopts = 1;
E 5
	/* If the current state is not 'STARTED', then we are not prepared to do
	 * the linkup */
D 3
	if (dbmysqlmodstate != MODSTATE_STARTED)
E 3
I 3
	if (dbmysqlmodule.state != MODSTATE_STARTED)
E 3
		return VMBADSTATE;
	/* show that we are doing linkup */
D 3
	dbmysqlmodstate = MODSTATE_LINKUPINPROGRESS;
E 3
I 3
	dbmysqlmodule.state = MODSTATE_LINKUPINPROGRESS;
E 3

I 5
	/* Get mysql options from config file */
D 6
	confgetoptionsfromsection("KDBMyDSQL", copt, numopts);
E 6
I 6
	confgetoptionsfromsection("KDBMySQL", copt, numopts);
E 6

	if (enablemysql)
	{
		/* Since the mysql database is enabled, we need to connect to the
		 * server.  If we can connect successfully, then we can now use the
		 * mysql database as our backend database */
I 6
D 7
		logmsg("Connecting to database");
E 7
I 7
		logmsg(LOGINFO, "Connecting to database");
E 7
E 6
	}

E 5
	/* Linkup complete */
D 3
	dbmysqlmodstate = MODSTATE_LINKED;
E 3
I 3
	dbmysqlmodule.state = MODSTATE_LINKED;
E 3

	/* Everything Happy :) */
	return VMSUCCESS;
}

/* dbshutdown - close off the database and clean up any external connections
 */
D 3
vmerr_t dbmysqlshutdown(void)
E 3
I 3
int dbmysqlshutdown(void)
E 3
{
	/* Can't shutdown unless we are currently 'linked' */
D 3
	if (dbmysqlmodstate != MODSTATE_LINKED)
E 3
I 3
	if (dbmysqlmodule.state != MODSTATE_LINKED)
E 3
		return VMBADSTATE;
	/* show that we are doing shutdown */
D 3
	dbmysqlmodstate = MODSTATE_SHUTDOWNINPROGRESS;
E 3
I 3
	dbmysqlmodule.state = MODSTATE_SHUTDOWNINPROGRESS;
E 3

	/* shutdown complete */
D 3
	dbmysqlmodstate = MODSTATE_STOPPED;
E 3
I 3
	dbmysqlmodule.state = MODSTATE_STOPPED;
E 3

	/* Everything Happy :) */
I 5
	return VMSUCCESS;
}

/* dbmysqlbuilddb - Builds mysql object tables
 * 	Should only be called to entirely wipe out the object database
 * 	This should not be called unless we have already done linkup to the
 * 	database server */
int dbmysqlbuilddb(void)
{
	char dropobjtable1[] = "drop table if exists mainobjtable";
	char dropobjtable2[] = "drop table if exists largeobjtable";
	char dropobjtable3[] = "drop table if exists objtracker";
	char mainobjtablestmt[] = "create table mainobjtable (objhash int unsigned"
		" primary key,  obj mediumblob not null)";
	char largeobjtablestmt[] = "create table largeobjtable (objhash int"
		" unsigned primary key,  obj longblob not null)";
	char objtrackerstmt[] = "create table objtracker (objhash int unsigned"
		" primary key );";

E 5
	return VMSUCCESS;
}
E 2
I 1
E 1
