/* @(#) llist.h 1.6 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*
*	Module: Daemon
\***************************************************************/

#ifndef _KOALAMUD_LLIST_H
#define _KOALAMUD_LLIST_H "@(#) nitehawk@winghove.1ststep.net|include/llist.h|20000307194808|12413 @(#)"

#include "koalatypes.h"

/* No lists should expect any node other then the head node to stay intact.
 * Nodes other then the head node may be freed, even if the data is not
 * removed from the list or freed as a result of the head node getting freed.
 */
/* Structures */

/* This is the structure for a linked list.  It may be cloned to make list
 * management easier.  Just copy the structure and change the type of the
 * data pointer to suit the list type.
 * All management functions operate on the data as a listdata pointer
 */
typedef struct TAG_LISTNODE
{
	struct TAG_LISTNODE *head;
	struct TAG_LISTNODE *prev;
	struct TAG_LISTNODE *next;
	union {
		void *generic;
		pdescriptor desc;
	} data;
} listnode;
typedef listnode *listnodeptr;

/* Prototypes */
listnodeptr listcreate(void *data);
int listaddnode(listnodeptr list, void *data);
int listremovenode(listnodeptr list, void *data);
listnodeptr listnextnode(listnodeptr list);
listnodeptr listprevnode(listnodeptr list);
void listdestroy(listnodeptr list);

#endif
