/***************************************************************************
                          setpagedisplay.h  -  description
                             -------------------
    begin                : Thu Aug 16 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETPAGEDISPLAY_H
#define SETPAGEDISPLAY_H

#include <klineedit.h>
#include <kcombobox.h>
#include <qtextview.h>
#include <qtabwidget.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qlayout.h>
#include "resource.h"

/**
  *@author Troy Corbin Jr.
  */

class setPageDisplay : public QVBoxLayout
{
   Q_OBJECT

	public:
													setPageDisplay(QWidget *parent=0, resource *Rsrc=0);
													~setPageDisplay();
		void									buildThemeList( void );
		int										NewBoards;
		int										NewChessmen;
		bool									changeTheme;
		bool									refreshBoard;
		bool									rebuildConsole;
					
	public slots:
		void									slotCurrent_Boards( int );
		void									slotCurrent_Chessmen( int );
		void									slotCurrent_Theme_Size( int );
		void									slotToggle_Board_Orientation( bool );
		void									slotToggle_Splashscreen( bool );
		void									slotToggle_Auto_Preview( bool );
		void									slotToggle_Show_Last_Move( bool );
		void									slotToggle_Animate_Move( bool );
		void									slotToggle_Show_Coord( bool );
		void									slot_SCID_Images( const QString& );
		void									slot_SCID_Images_Button( void );

		void									slot_setDefault(void);

		void									slot_Color_Background(void);
		void									slot_Color_Standard(void);
		void									slot_Color_PrivateTell(void);
		void									slot_Color_ChannelTell(void);
		void									slot_Color_Shout(void);
		void									slot_Color_Whisper(void);
		void									slot_Color_Notification(void);
		void									slot_Font_Standard(void);
		void									slot_Font_PrivateTell(void);
		void									slot_Font_ChannelTell(void);
		void									slot_Font_Shout(void);
		void									slot_Font_Whisper(void);
		void									slot_Font_Notification(void);
		
	signals:
		void									enableApply( void );

	protected:
		void									initTab1( void );
		void									initTab2( void );
		void									resetSampleConsole( void );
	
	private:
		resource							*Resource;
		int										margin;

		QTabWidget						*TabParent;

													/* Tab 1 : General */
		QVBox									*Tab1;
			QHBox									*BOX_Themes;
				QGroupBox							*GROUP_Boards;
					KComboBox							*Current_Boards;
				QGroupBox							*GROUP_Chessmen;
					KComboBox							*Current_Chessmen;
			QGroupBox							*GROUP_Theme_Size;
				QLabel								*Size_Min;
				QSlider								*Current_Theme_Size;
				QLabel								*Size_Max;
			QGroupBox							*GROUP_SCID_Images;
				KLineEdit							*EDIT_SCID_Images;
				QPushButton						*BUTTON_SCID_Images;
			QGroupBox							*GROUP_General_Graphics;
				QCheckBox							*Board_Orientation;
				QCheckBox							*Show_Splashscreen;
				QCheckBox							*Auto_Preview;
				QCheckBox							*Show_Last_Move;
				QCheckBox							*Animate_Move;
				QCheckBox							*Show_Coord;

													/* Tab 2 : Console */
		QFrame								*Tab2;
			QGridLayout							*GRID_Style;
				QTextView								*Console_Sample;
				QPushButton							*Default_Button;
				QPushButton							*Fonts_Button_Standard;
				QPushButton							*Fonts_Button_PrivateTell;
				QPushButton							*Fonts_Button_ChannelTell;
				QPushButton							*Fonts_Button_Shout;
				QPushButton							*Fonts_Button_Whisper;
				QPushButton							*Fonts_Button_Notification;
				QPushButton							*Colors_Button_Standard;
				QPushButton							*Colors_Button_PrivateTell;
				QPushButton							*Colors_Button_ChannelTell;
				QPushButton							*Colors_Button_Shout;
				QPushButton							*Colors_Button_Whisper;
				QPushButton							*Colors_Button_Notification;
				QPushButton							*Colors_Button_Background;
};

#endif
