/***************************************************************************
                   challenge_graph_view.h  -  description
                             -------------------
    begin                : Mon Jan 7 2002
    copyright            : (C) 2003 by Eric Faccer
    email                : e.faccer@qut.edu.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHALLENGE_GRAPH_VIEW_H
#define CHALLENGE_GRAPH_VIEW_H

#include <qevent.h>
#include <qcanvas.h>
#include <qlabel.h>
#include "challenge_game.h"


class Challenge_Graph_View : public QCanvasView
{
    Q_OBJECT

	public:
		Challenge_Graph_View(QCanvas&, QWidget* parent=0, const char* name=0, WFlags f=0, QLabel *qsb=0);
		~Challenge_Graph_View();
		void reset();

	signals:
		void leftClick(int);
		void rightClick(Challenge_Game*, const QPoint&);

	protected:
		void contentsMousePressEvent(QMouseEvent*);
		void contentsMouseMoveEvent(QMouseEvent*);
		void updateStatusBar(QString msg);

	private:
		QCanvas &canvas;
		QLabel *statusbar;
};

#endif
