/* -*- c++ -*-
 *
 * closabletab.cpp
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@kmldonkey.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

/*
 * NOTE: The vast majority of this code was taken from QTella 0.6.1.
 */

#include <kdeversion.h>

#include "closabletab.h"

#include <qiconset.h>
#include <qpainter.h>
#include <kiconloader.h>

ClosableTabBar::ClosableTabBar(QWidget *parent, const char *name)
  : QTabBar(parent, name)
{
  //connect(this, SIGNAL(selected(int)), parent,
}

//! For our ends we just had to reimplement mouseReleaseEvent()

void ClosableTabBar::mouseReleaseEvent(QMouseEvent *e)
{

  if (e->button() != LeftButton)
    return;

  /* emit signal that mouse was within icon. We assume that mousePressEvent()
     has been called before and the correct tab has already been selected.  */
  if (withinIcon(tab(currentTab()), e->pos()))
    {
      emit iconPressed();
    }

}

bool ClosableTabBar::withinIcon(const QTab * t, const QPoint & point)
{

  if (t == 0 ||
#if QT_VERSION < 300
       t->iconset
#else
       t->iconSet()
#endif
      == 0 )
    return false;

#if QT_VERSION < 300
  QRect r(t->r);
#else
  QRect r(t->rect());
#endif

  /* don't know if that's a good way, we could destroy something if ClosableTabBar */
  QPainter painter(this);
  painter.setFont(font());

  int pixw = 0;
  int pixh = 0;
  int iw = 0;

#if QT_VERSION < 300
  pixw = t->iconset->pixmap( QIconSet::Small, QIconSet::Normal ).width();
  pixh = t->iconset->pixmap( QIconSet::Small, QIconSet::Normal ).height();
#else
  pixw = t->iconSet()->pixmap( QIconSet::Small, QIconSet::Normal ).width();
  pixh = t->iconSet()->pixmap( QIconSet::Small, QIconSet::Normal ).height();
#endif
  iw = pixw + 2;

#if QT_VERSION < 300
  int w = iw + painter.fontMetrics().width(t->label) + 4;
#else
  int w = iw + painter.fontMetrics().width(t->text()) + 4;
#endif
  int h = QMAX(painter.fontMetrics().height() + 4, pixh);

  QRect tmp(r.left() + (r.width()-w)/2 - 3, r.top() + (r.height()-h)/2, w, h);

  QRect p(tmp.left() + 2, tmp.center().y() - pixh / 2, pixw, pixh);
  if (!p.isEmpty())
    {
      return p.contains(point);
    }

  return false;
}

ClosableTabWidget::ClosableTabWidget(QWidget *parent, const char *name)
  : QTabWidget(parent, name)
{
  //_parent = (QtellaSub*)parent;

  setTabBar(new ClosableTabBar());
  connect(tabBar(), SIGNAL(iconPressed()), this, SLOT(slotIconPressed()));
  connect(this, SIGNAL(currentChanged(QWidget*)), SLOT(slotCurrentChanged(QWidget*)));
}

void ClosableTabWidget::slotIconPressed()
{
    emit closeRequest(currentPage());
}

void ClosableTabWidget::slotCurrentChanged(QWidget* w)
{
  emit sigCurrentChanged(w);
  ////_parent->slotCurrentChanged(w);
}

void ClosableTabWidget::addTab(QWidget* child, const QIconSet&, const QString& label)
{
    QTabWidget::addTab(child, KGlobal::iconLoader()->loadIconSet("fileclose", KIcon::Small), label);
}

#include "closabletab.moc"


