/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2004	  by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#include "projectpref.h"
#include "projectprefwidgets.h"

#include <qlayout.h>
#include <qwhatsthis.h>
#include <qvbox.h>

#include <klocale.h>
#include <kiconloader.h>
#include <kapplication.h>


#define PAGE_IDENTITY 		0
#define PAGE_SAVE     		1
#define PAGE_SPELL    		2
#define PAGE_SOURCE   		3
#define PAGE_MISC     		4
#define PAGE_CATMAN       	5
#define PAGE_DIRCOMMANDS  	6
#define PAGE_FILECOMMANDS 	7
#define PAGE_VIEW         	8

using namespace KBabel;

ProjectDialog::ProjectDialog(Project::Ptr project)
    : KDialogBase(IconList, i18n("Project Properties"),
                  Help|Default|Ok|Apply|Cancel, Ok,0,0,false)
    , _project( project )
{
    
    QVBox *frame;
    frame = addVBoxPage(i18n("title of page in preferences dialog","Identity")
               , i18n("Information About You and Translation Team")
               ,UserIcon("pref_identity"));
    _identityPage = new IdentityPreferences(frame, project->name());
    _identityPage->setSettings(project->identitySettings());

    frame = addVBoxPage(i18n("title of page in preferences dialog","Save")
            , i18n("Options for File Saving"),BarIcon("filesave",32));
    _savePage = new SavePreferences(frame);
    _savePage->setSettings(project->saveSettings());


    frame = addVBoxPage(i18n("title of page in preferences dialog","Spelling")
            , i18n("Options for Spell Checking"), BarIcon("spellcheck",32));
    _spellPage = new SpellPreferences(frame);
    _spellPage->setSettings(project->spellcheckSettings());


    frame = addVBoxPage(i18n("title of page in preferences dialog","Source")
                ,i18n("Options for Showing Source Context"),BarIcon("source",32));
    _sourcePage = new SourceContextPreferences(frame);
    _sourcePage->setSettings(project->sourceContextSettings());

    frame = addVBoxPage(i18n("title of page in preferences dialog","Miscellaneous")
                ,i18n("Miscellaneous Settings"),DesktopIcon("misc"));
    _miscPage = new MiscPreferences(frame);
    _miscPage->setSettings(project->miscSettings());

    frame = addVBoxPage(i18n("title of page in preferences dialog","Folders")
               , i18n("Paths to Message Catalogs & Catalog Templates")
               ,BarIcon("catalogmanager",32));
    _catmanPage = new CatmanPreferences(frame);
    _catmanPage->setSettings(project->catManSettings());

    frame = addVBoxPage(i18n("title of page in preferences dialog","Folder Commands")
               , i18n("User-Defined Commands for Folder Items")
               ,DesktopIcon("folder",32));
    _dirCommandsPage = new DirCommandsPreferences(frame);
    _dirCommandsPage->setSettings(project->catManSettings());

    frame = addVBoxPage(i18n("title of page in preferences dialog","File Commands")
               , i18n("User-Defined Commands for File Items")
               ,DesktopIcon("files",32));
    _fileCommandsPage = new FileCommandsPreferences(frame);
    _fileCommandsPage->setSettings(project->catManSettings());

    frame = addVBoxPage(i18n("title of page in preferences dialog","Catalog Manager")
               , i18n("Catalog Manager View Settings")
               ,DesktopIcon("view_tree",32));
    _viewPage = new ViewPreferences(frame);
    _viewPage->setSettings(project->catManSettings());

    adjustSize();

    _spellcheckSettings = project->spellcheckSettings();
    _saveSettings = project->saveSettings();
    _idSettings = project->identitySettings();
    _miscSettings = project->miscSettings();
    _sourceSettings = project->sourceContextSettings();
    _CatManSettings = project->catManSettings();
}


void ProjectDialog::updateIdentitySettings(IdentitySettings settings)
{
    _identityPage->setSettings(settings);
    _idSettings=settings;
}


void ProjectDialog::updateSaveSettings(SaveSettings settings)
{
    _savePage->setSettings(settings);
    _saveSettings=settings;
}

void ProjectDialog::updateMiscSettings(MiscSettings settings)
{
	_miscPage->setSettings(settings);
	_miscSettings = settings;
}

void ProjectDialog::updateSourceContextSettings(SourceContextSettings settings)
{
	_sourcePage->setSettings(settings);
	_sourceSettings = settings;
}

void ProjectDialog::updateCatManSettings(CatManSettings settings)
{
    _catmanPage->setSettings(settings);
    _dirCommandsPage->setSettings(settings);
    _fileCommandsPage->setSettings(settings);
    _viewPage->setSettings(settings);
    _CatManSettings=settings;
}

void ProjectDialog::slotHelp()
{
   //TODO
   kapp->invokeHelp("Preferences","");
}

void ProjectDialog::slotDefault()
{
   switch(activePageIndex())
   {
      case PAGE_IDENTITY:
         _identityPage->defaults();
         break;
      case PAGE_SAVE:
        _savePage->defaults();
        break;
      case PAGE_MISC:
	  _miscPage->defaults();
	  break;
      case PAGE_SPELL:
         _spellPage->defaults();
         break;
      case PAGE_SOURCE:
         _sourcePage->defaults();
         break;
      case PAGE_CATMAN:
         _catmanPage->defaults();
         break;
      case PAGE_DIRCOMMANDS:
         _dirCommandsPage->defaults();
         break;
      case PAGE_FILECOMMANDS:
         _fileCommandsPage->defaults();
         break;
      case PAGE_VIEW:
         _viewPage->defaults();
         break;
      default:
        break;
   }
}

void ProjectDialog::slotApply()
{
   QStringList list;

   switch(activePageIndex())
   {
      case PAGE_IDENTITY:
         _identityPage->mergeSettings(_idSettings);
	 _project->setSettings(_idSettings);
         break;
      case PAGE_SAVE:
         _savePage->mergeSettings(_saveSettings);
	 _project->setSettings(_saveSettings);
        break;
      case PAGE_MISC:
	 _miscPage->mergeSettings(_miscSettings);
	 _project->setSettings(_miscSettings);
      case PAGE_SPELL:
         _spellPage->mergeSettings(_spellcheckSettings);
	 _project->setSettings(_spellcheckSettings);
         break;
      case PAGE_SOURCE:
         _sourcePage->mergeSettings(_sourceSettings);
	 _project->setSettings(_sourceSettings);
         break;
      case PAGE_CATMAN:
      case PAGE_DIRCOMMANDS:
      case PAGE_FILECOMMANDS:
      case PAGE_VIEW:
         _catmanPage->mergeSettings(_CatManSettings);
	 _project->setSettings(_CatManSettings);
         break;
      default:
        break;
   }

}

void ProjectDialog::slotOk()
{
   _identityPage->mergeSettings(_idSettings);
   _savePage->mergeSettings(_saveSettings);
   _spellPage->mergeSettings(_spellcheckSettings);
   _miscPage->mergeSettings(_miscSettings);
   _catmanPage->mergeSettings(_CatManSettings);
   _dirCommandsPage->mergeSettings(_CatManSettings);
   _fileCommandsPage->mergeSettings(_CatManSettings);
   _viewPage->mergeSettings(_CatManSettings);
   
   _project->setSettings(_idSettings);
   _project->setSettings(_saveSettings);
   _project->setSettings(_spellcheckSettings);
   _project->setSettings(_miscSettings);
   _project->setSettings(_CatManSettings);
   _project->setSettings(_CatManSettings);
   _project->setSettings(_CatManSettings);
   _project->setSettings(_CatManSettings);

   QDialog::accept();
}

void ProjectDialog::slotCancel()
{
    _identityPage->setSettings(_idSettings);
    _savePage->setSettings(_saveSettings);
    _spellPage->setSettings(_spellcheckSettings);
    _miscPage->setSettings(_miscSettings);
    _sourcePage->setSettings( _sourceSettings );
    _catmanPage->setSettings(_CatManSettings);
    _dirCommandsPage->setSettings(_CatManSettings);
    _fileCommandsPage->setSettings(_CatManSettings);
    _viewPage->setSettings(_CatManSettings);

    QDialog::reject();
}


#include "projectpref.moc"
