/***************************************************************************
                          JavaSlot.h  -  description
                             -------------------
    begin                : Tue Oct 31 2000
    copyright            : (C) 2000 by Richard Dale
    email                : Richard_Dale@tipitina.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   Lost Highway Ltd reserves the right to issue additional license types *
 *   compatible with the Trolltech AS Qt commercial license.               *
 ***************************************************************************/

#ifndef _JAVASLOT_H_
#define _JAVASLOT_H_

#include <jni.h>
#include <qobject.h>

#include <qevent.h>
#include <qlistview.h>
#include <qiconview.h>
#include <qlistbox.h>
#include <qdatetime.h>
#include <qtoolbar.h>
#include <qaction.h>
#include <qnetworkprotocol.h>
#include <qsql.h>
#include <qsqlcursor.h>
#include <qsqlrecord.h>
#include <qurlinfo.h>
#include <qlibrary.h>
#include <qhttp.h>
#include <qdir.h>
#include <qtextedit.h>

class JavaSlotFactory;
class QMetaObject;

class JavaSlot: public QObject
{
    Q_OBJECT
public:
    JavaSlot(JNIEnv * env, jobject receiver, jstring slot);
    ~JavaSlot();
	
	/** Set the JavaSlot factory to create any JavaSlot instances */
	static void setJavaSlotFactory(JavaSlotFactory * factory);

    /** Return a new JavaSlot instance via the JavaSlot factory */
	static JavaSlot * createJavaSlot(JNIEnv * env, jobject receiver, jstring slot);

	/** Given a Java signal name, returns the corresponding C++ signal name.
		The QMetaObject is used to check whether the QObject instance described
		by 'smeta' implements the C++ signal. */
	const char * javaToQtSignalName(JNIEnv * env, jstring signalString, QMetaObject * smeta);
	
	/** Converts a Java type signature for a signal to the corresponding C++ Qt type signature.*/
	virtual const char * javaToQtSignalType(const char * signalName, const char * javaTypeSignature, QMetaObject * smeta);

	/** Given a Java slot name, returns the corresponding C++ slot name. The optional signalString
		parameter is the C++ signal to connect to - any C++ slot type signature must match this.
	*/
	const char * javaToQtSlotName(JNIEnv * env, jstring slotString, const char * signalString = 0);

	/** Converts a Java type signature for a slot to the corresponding C++ Qt type signature.*/
	virtual const char * javaToQtSlotType(const char * javaTypeSignature, const char * signalString);

public slots:
    void invoke();
    void invoke(bool arg);
	void invoke(bool* arg1, bool* arg2);
    void invoke(char arg);
    void invoke(double arg);
    void invoke(float arg);
    void invoke(int arg);
    void invoke(int arg1, bool arg2);
    void invoke(int arg1,const QCString& arg2,const QByteArray& arg3);
    void invoke(int arg1,const QPoint& arg2);
    void invoke(int arg1,const QString& arg2);
    void invoke(int arg1,int arg2);
    void invoke(int arg1,int arg2,const QPoint& arg3);
	void invoke(int arg1,int arg2,int arg3);
	void invoke(int arg1,int arg2,int arg3,const QPoint& arg4);
	void invoke(int arg1,int arg2,QNetworkOperation* arg3);
	void invoke(int arg1,QDropEvent* arg2);
	void invoke(int arg1,QIconViewItem* arg2,const QPoint& arg3);
	void invoke(int arg1,QListBoxItem* arg2,const QPoint arg3);
	void invoke(int arg1,QListViewItem* arg2,const QPoint arg3,int arg4);
    void invoke(long arg);
    void invoke(long arg,const QByteArray&);
    void invoke(long arg,const QString&);
    void invoke(short arg);
    void invoke(unsigned char arg);
	void invoke(QAction * arg1);
	void invoke(QDir::SortSpec arg1);
	void invoke(QDockWindow * arg1);
	void invoke(QDockWindow::Place arg1);
	void invoke(QDropEvent* arg1);
	void invoke(QDropEvent* arg1,QListViewItem*arg2);
	void invoke(QDropEvent* arg1,const QValueList<QIconDragItem>& arg2);
	void invoke(QDropEvent*arg1,QListViewItem*arg2,QListViewItem*arg3);
	void invoke(QIconViewItem* arg1);
	void invoke(QIconViewItem* arg1,const QPoint& arg2);
	void invoke(QIconViewItem* arg1,const QString& arg2);
	void invoke(QList<QListViewItem> arg1,QList<QListViewItem> arg2,QList<QListViewItem> arg3);
	void invoke(QListBoxItem* arg1);
	void invoke(QListBoxItem* arg1,const QPoint& arg2);
	void invoke(QListViewItem* arg1, int arg2, const QString& arg3);
	void invoke(QListViewItem* arg1,QListViewItem*arg2,QListViewItem*arg3);
	void invoke(QListViewItem* arg1,const QPoint& arg2,int arg3);
	void invoke(QListViewItem* arg1,const QString& arg2,int arg3);
	void invoke(QListViewItem* arg1,int arg2);
	void invoke(QListViewItem*arg1);
	void invoke(QNetworkOperation* arg1);
	void invoke(QObject* arg1);
	void invoke(QPopupMenu* arg1);
	void invoke(QSql::Op arg1);
	void invoke(QSqlCursor::Mode arg1);
	void invoke(QSqlRecord* arg1);
	void invoke(QTextEdit::VerticalAlignment arg1);
	void invoke(QToolBar* arg1);
	void invoke(Orientation arg1);
	void invoke(QWidget* arg1);
	void invoke(QWidget* arg1,const QPoint& arg2);
	void invoke(QWidget* arg1,const QString& arg2);
	void invoke(QWidget* arg1,const QDropEvent* arg2);
	void invoke(QWidget* arg1,QPixmap arg2);
	void invoke(const QByteArray& arg1);
	void invoke(const QByteArray& arg1,QNetworkOperation* arg2);
	void invoke(const char* arg1, bool arg2);
	void invoke(const char* arg1,const QString& arg2,const QByteArray& arg3,const QString& arg4,const QString& arg5,const QString& arg6);
	void invoke(const QChar& arg1);
	void invoke(const QCString& arg1);
	void invoke(const QColor& arg1);
	void invoke(const QColor& arg1,const QString& arg2);
	void invoke(const QDate& arg1);
	void invoke(const QDate& arg1,const QDate& arg2);
	void invoke(const QDateTime& arg1);
	void invoke(const QDragMoveEvent* arg1,bool& arg2);
	void invoke(const QSize& arg1);
	void invoke(const QFont& arg1);
	void invoke(const QHttpResponseHeader& arg1);
	void invoke(const QImage& arg1, int arg2);
	void invoke(const QPixmap& arg1);
	void invoke(const QPoint& arg1);
	void invoke(const QRect& arg1);
	void invoke(const QSqlRecord* arg1);
	void invoke(const QString& arg1);
	void invoke(const QString& arg1,bool arg2,const QString& arg3);
	void invoke(const QString& arg1,const QCString& arg1,const QString& arg3);
	void invoke(const QString& arg1,QLibrary* arg2);
	void invoke(const QString& arg1,const QPoint& arg2);
	void invoke(const QString& arg1,const QString& arg2);
	void invoke(const QString& arg1,const QStringList& arg2,unsigned int arg3);
	void invoke(const QString& arg1,const QString& arg2,unsigned int arg3);
	void invoke(const QString& arg1,int arg2);
	void invoke(const QString& arg1,int arg2,int arg3);
	void invoke(const QString& arg1,int arg2,int arg3,int arg4);
	void invoke(const QStringList& arg1);
	void invoke(const QTime& arg1);
	void invoke(const QString& arg1,unsigned long arg2,unsigned long arg3,unsigned long arg4);
	void invoke(const QUrlInfo& arg1);
	void invoke(const QUrlInfo& arg1,QNetworkOperation* arg2);
	void invoke(const QValueList<QUrlInfo>& arg1,QNetworkOperation* arg2);
	void invoke(const QVariant& arg1);
	void invoke(const unsigned long& arg1,const unsigned long& arg2,const unsigned long& arg3,const QString& arg4);
	
    /** Java signals are always of type 'jobjectArray' */
	void invoke(jobjectArray args);

protected:
    jobject invocation;
private:
    static JavaSlotFactory *	_factory;
};

class JavaSlotFactory {
public:
	JavaSlotFactory();
	virtual ~JavaSlotFactory() {};
	virtual JavaSlot *	createJavaSlot(JNIEnv * env, jobject receiver, jstring slot);
};

class JavaSignal: public QObject
{
    Q_OBJECT
public:
    JavaSignal();
    ~JavaSignal();
    void emitArgs(jobjectArray args);
signals:
    void signalJava(jobjectArray);
};

#endif




